/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.javaapi.data.DamlGenMap;
import com.daml.ledger.javaapi.data.DamlList;
import com.daml.ledger.javaapi.data.DamlTextMap;
import com.daml.ledger.javaapi.data.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;

public final class DamlCollectors {
    public static <T> Collector<T, List<Value>, DamlList> toDamlList(Function<T, Value> valueMapper) {
        return Collector.of(ArrayList::new, (acc, entry) -> acc.add((Value)valueMapper.apply(entry)), (left, right) -> {
            left.addAll(right);
            return left;
        }, DamlList::fromPrivateList, new Collector.Characteristics[0]);
    }

    public static Collector<Value, List<Value>, DamlList> toDamlList() {
        return DamlCollectors.toDamlList(Function.identity());
    }

    public static <T> Collector<T, Map<String, Value>, DamlTextMap> toDamlTextMap(Function<T, String> keyMapper, Function<T, Value> valueMapper) {
        return Collector.of(HashMap::new, (acc, entry) -> acc.put((String)keyMapper.apply(entry), (Value)valueMapper.apply(entry)), (left, right) -> {
            left.putAll(right);
            return left;
        }, DamlTextMap::fromPrivateMap, new Collector.Characteristics[0]);
    }

    public static Collector<Map.Entry<String, Value>, Map<String, Value>, DamlTextMap> toDamlTextMap() {
        return DamlCollectors.toDamlTextMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> Collector<T, Map<Value, Value>, DamlGenMap> toDamlGenMap(Function<T, Value> keyMapper, Function<T, Value> valueMapper) {
        return Collector.of(LinkedHashMap::new, (acc, entry) -> acc.put((Value)keyMapper.apply(entry), (Value)valueMapper.apply(entry)), (left, right) -> {
            left.putAll(right);
            return left;
        }, DamlGenMap::fromPrivateMap, new Collector.Characteristics[0]);
    }

    public static Collector<Map.Entry<Value, Value>, Map<Value, Value>, DamlGenMap> toMap() {
        return DamlCollectors.toDamlGenMap(Map.Entry::getKey, Map.Entry::getValue);
    }
}

