/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen;

import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.DamlRecord;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.javaapi.data.codegen.ContractId;
import com.daml.ledger.javaapi.data.codegen.ContractTypeCompanion;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public abstract class ContractCompanion<Ct, Id, Data>
extends ContractTypeCompanion {
    final String templateClassName;
    protected final Function<String, Id> newContractId;
    protected final Function<DamlRecord, Data> fromValue;

    public abstract Ct fromCreatedEvent(CreatedEvent var1);

    public Id toContractId(ContractId<Data> parameterizedContractId) {
        return this.newContractId.apply(parameterizedContractId.contractId);
    }

    protected ContractCompanion(String templateClassName, Identifier templateId, Function<String, Id> newContractId, Function<DamlRecord, Data> fromValue) {
        super(templateId);
        this.templateClassName = templateClassName;
        this.newContractId = newContractId;
        this.fromValue = fromValue;
    }

    public static final class WithKey<Ct, Id, Data, Key>
    extends ContractCompanion<Ct, Id, Data> {
        private final NewContract<Ct, Id, Data, Key> newContract;
        private final Function<Value, Key> keyFromValue;

        public WithKey(String templateClassName, Identifier templateId, Function<String, Id> newContractId, Function<DamlRecord, Data> fromValue, NewContract<Ct, Id, Data, Key> newContract, Function<Value, Key> keyFromValue) {
            super(templateClassName, templateId, newContractId, fromValue);
            this.newContract = newContract;
            this.keyFromValue = keyFromValue;
        }

        public Ct fromIdAndRecord(String contractId, DamlRecord record$, Optional<String> agreementText, Optional<Key> key, Set<String> signatories, Set<String> observers) {
            Object id = this.newContractId.apply(contractId);
            Object data = this.fromValue.apply(record$);
            return this.newContract.newContract(id, data, agreementText, key, signatories, observers);
        }

        @Override
        public Ct fromCreatedEvent(CreatedEvent event) {
            return this.fromIdAndRecord(event.getContractId(), event.getArguments(), event.getAgreementText(), event.getContractKey().map(this.keyFromValue), event.getSignatories(), event.getObservers());
        }

        @FunctionalInterface
        public static interface NewContract<Ct, Id, Data, Key> {
            public Ct newContract(Id var1, Data var2, Optional<String> var3, Optional<Key> var4, Set<String> var5, Set<String> var6);
        }
    }

    public static final class WithoutKey<Ct, Id, Data>
    extends ContractCompanion<Ct, Id, Data> {
        private final NewContract<Ct, Id, Data> newContract;

        public WithoutKey(String templateClassName, Identifier templateId, Function<String, Id> newContractId, Function<DamlRecord, Data> fromValue, NewContract<Ct, Id, Data> newContract) {
            super(templateClassName, templateId, newContractId, fromValue);
            this.newContract = newContract;
        }

        public Ct fromIdAndRecord(String contractId, DamlRecord record$, Optional<String> agreementText, Set<String> signatories, Set<String> observers) {
            Object id = this.newContractId.apply(contractId);
            Object data = this.fromValue.apply(record$);
            return this.newContract.newContract(id, data, agreementText, signatories, observers);
        }

        @Override
        public Ct fromCreatedEvent(CreatedEvent event) {
            return this.fromIdAndRecord(event.getContractId(), event.getArguments(), event.getAgreementText(), event.getSignatories(), event.getObservers());
        }

        @FunctionalInterface
        public static interface NewContract<Ct, Id, Data> {
            public Ct newContract(Id var1, Data var2, Optional<String> var3, Set<String> var4, Set<String> var5);
        }
    }
}

