/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.EventOuterClass;
import com.daml.ledger.javaapi.data.Event;
import com.daml.ledger.javaapi.data.Identifier;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ArchivedEvent
implements Event {
    private final List<String> witnessParties;
    private final String eventId;
    private final Identifier templateId;
    private final String contractId;

    public ArchivedEvent(@NonNull List<@NonNull String> witnessParties, @NonNull String eventId, @NonNull Identifier templateId, @NonNull String contractId) {
        this.witnessParties = witnessParties;
        this.eventId = eventId;
        this.templateId = templateId;
        this.contractId = contractId;
    }

    @Override
    public @NonNull List<@NonNull String> getWitnessParties() {
        return this.witnessParties;
    }

    @Override
    public @NonNull String getEventId() {
        return this.eventId;
    }

    @Override
    public @NonNull Identifier getTemplateId() {
        return this.templateId;
    }

    @Override
    public @NonNull String getContractId() {
        return this.contractId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchivedEvent that = (ArchivedEvent)o;
        return Objects.equals(this.witnessParties, that.witnessParties) && Objects.equals(this.eventId, that.eventId) && Objects.equals(this.templateId, that.templateId) && Objects.equals(this.contractId, that.contractId);
    }

    public int hashCode() {
        return Objects.hash(this.witnessParties, this.eventId, this.templateId, this.contractId);
    }

    public String toString() {
        return "ArchivedEvent{witnessParties=" + this.witnessParties + ", eventId='" + this.eventId + "', templateId=" + this.templateId + ", contractId='" + this.contractId + "'}";
    }

    public EventOuterClass.ArchivedEvent toProto() {
        return EventOuterClass.ArchivedEvent.newBuilder().setContractId(this.getContractId()).setEventId(this.getEventId()).setTemplateId(this.getTemplateId().toProto()).addAllWitnessParties(this.getWitnessParties()).build();
    }

    public static ArchivedEvent fromProto(EventOuterClass.ArchivedEvent archivedEvent) {
        return new ArchivedEvent((List<String>)archivedEvent.getWitnessPartiesList(), archivedEvent.getEventId(), Identifier.fromProto(archivedEvent.getTemplateId()), archivedEvent.getContractId());
    }
}

