package com.daml.ledger.api.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Allows clients to read transactions from the ledger.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/transaction_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class TransactionServiceGrpc {

  private TransactionServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.TransactionService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsResponse> getGetTransactionsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetTransactions",
      requestType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest.class,
      responseType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsResponse> getGetTransactionsMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsResponse> getGetTransactionsMethod;
    if ((getGetTransactionsMethod = TransactionServiceGrpc.getGetTransactionsMethod) == null) {
      synchronized (TransactionServiceGrpc.class) {
        if ((getGetTransactionsMethod = TransactionServiceGrpc.getGetTransactionsMethod) == null) {
          TransactionServiceGrpc.getGetTransactionsMethod = getGetTransactionsMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetTransactions"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TransactionServiceMethodDescriptorSupplier("GetTransactions"))
              .build();
        }
      }
    }
    return getGetTransactionsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionTreesResponse> getGetTransactionTreesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetTransactionTrees",
      requestType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest.class,
      responseType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionTreesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionTreesResponse> getGetTransactionTreesMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionTreesResponse> getGetTransactionTreesMethod;
    if ((getGetTransactionTreesMethod = TransactionServiceGrpc.getGetTransactionTreesMethod) == null) {
      synchronized (TransactionServiceGrpc.class) {
        if ((getGetTransactionTreesMethod = TransactionServiceGrpc.getGetTransactionTreesMethod) == null) {
          TransactionServiceGrpc.getGetTransactionTreesMethod = getGetTransactionTreesMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionTreesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetTransactionTrees"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionTreesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TransactionServiceMethodDescriptorSupplier("GetTransactionTrees"))
              .build();
        }
      }
    }
    return getGetTransactionTreesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> getGetTransactionByEventIdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetTransactionByEventId",
      requestType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest.class,
      responseType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> getGetTransactionByEventIdMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> getGetTransactionByEventIdMethod;
    if ((getGetTransactionByEventIdMethod = TransactionServiceGrpc.getGetTransactionByEventIdMethod) == null) {
      synchronized (TransactionServiceGrpc.class) {
        if ((getGetTransactionByEventIdMethod = TransactionServiceGrpc.getGetTransactionByEventIdMethod) == null) {
          TransactionServiceGrpc.getGetTransactionByEventIdMethod = getGetTransactionByEventIdMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetTransactionByEventId"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TransactionServiceMethodDescriptorSupplier("GetTransactionByEventId"))
              .build();
        }
      }
    }
    return getGetTransactionByEventIdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> getGetTransactionByIdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetTransactionById",
      requestType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest.class,
      responseType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> getGetTransactionByIdMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> getGetTransactionByIdMethod;
    if ((getGetTransactionByIdMethod = TransactionServiceGrpc.getGetTransactionByIdMethod) == null) {
      synchronized (TransactionServiceGrpc.class) {
        if ((getGetTransactionByIdMethod = TransactionServiceGrpc.getGetTransactionByIdMethod) == null) {
          TransactionServiceGrpc.getGetTransactionByIdMethod = getGetTransactionByIdMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetTransactionById"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TransactionServiceMethodDescriptorSupplier("GetTransactionById"))
              .build();
        }
      }
    }
    return getGetTransactionByIdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> getGetFlatTransactionByEventIdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetFlatTransactionByEventId",
      requestType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest.class,
      responseType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> getGetFlatTransactionByEventIdMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> getGetFlatTransactionByEventIdMethod;
    if ((getGetFlatTransactionByEventIdMethod = TransactionServiceGrpc.getGetFlatTransactionByEventIdMethod) == null) {
      synchronized (TransactionServiceGrpc.class) {
        if ((getGetFlatTransactionByEventIdMethod = TransactionServiceGrpc.getGetFlatTransactionByEventIdMethod) == null) {
          TransactionServiceGrpc.getGetFlatTransactionByEventIdMethod = getGetFlatTransactionByEventIdMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetFlatTransactionByEventId"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TransactionServiceMethodDescriptorSupplier("GetFlatTransactionByEventId"))
              .build();
        }
      }
    }
    return getGetFlatTransactionByEventIdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> getGetFlatTransactionByIdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetFlatTransactionById",
      requestType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest.class,
      responseType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> getGetFlatTransactionByIdMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> getGetFlatTransactionByIdMethod;
    if ((getGetFlatTransactionByIdMethod = TransactionServiceGrpc.getGetFlatTransactionByIdMethod) == null) {
      synchronized (TransactionServiceGrpc.class) {
        if ((getGetFlatTransactionByIdMethod = TransactionServiceGrpc.getGetFlatTransactionByIdMethod) == null) {
          TransactionServiceGrpc.getGetFlatTransactionByIdMethod = getGetFlatTransactionByIdMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetFlatTransactionById"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TransactionServiceMethodDescriptorSupplier("GetFlatTransactionById"))
              .build();
        }
      }
    }
    return getGetFlatTransactionByIdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse> getGetLedgerEndMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetLedgerEnd",
      requestType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest.class,
      responseType = com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest,
      com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse> getGetLedgerEndMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse> getGetLedgerEndMethod;
    if ((getGetLedgerEndMethod = TransactionServiceGrpc.getGetLedgerEndMethod) == null) {
      synchronized (TransactionServiceGrpc.class) {
        if ((getGetLedgerEndMethod = TransactionServiceGrpc.getGetLedgerEndMethod) == null) {
          TransactionServiceGrpc.getGetLedgerEndMethod = getGetLedgerEndMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest, com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetLedgerEnd"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TransactionServiceMethodDescriptorSupplier("GetLedgerEnd"))
              .build();
        }
      }
    }
    return getGetLedgerEndMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static TransactionServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TransactionServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TransactionServiceStub>() {
        @java.lang.Override
        public TransactionServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TransactionServiceStub(channel, callOptions);
        }
      };
    return TransactionServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static TransactionServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TransactionServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TransactionServiceBlockingStub>() {
        @java.lang.Override
        public TransactionServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TransactionServiceBlockingStub(channel, callOptions);
        }
      };
    return TransactionServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static TransactionServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TransactionServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TransactionServiceFutureStub>() {
        @java.lang.Override
        public TransactionServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TransactionServiceFutureStub(channel, callOptions);
        }
      };
    return TransactionServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Allows clients to read transactions from the ledger.
   * </pre>
   */
  public static abstract class TransactionServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Read the ledger's filtered transaction stream for a set of parties.
     * Lists only creates and archives, but not other events.
     * Omits all events on transient contracts, i.e., contracts that were both created and archived in the same transaction.
     * </pre>
     */
    public void getTransactions(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetTransactionsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Read the ledger's complete transaction tree stream for a set of parties.
     * The stream can be filtered only by parties, but not templates (template filter must be empty).
     * </pre>
     */
    public void getTransactionTrees(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionTreesResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetTransactionTreesMethod(), responseObserver);
    }

    /**
     * <pre>
     * Lookup a transaction tree by the ID of an event that appears within it.
     * For looking up a transaction instead of a transaction tree, please see GetFlatTransactionByEventId
     * </pre>
     */
    public void getTransactionByEventId(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetTransactionByEventIdMethod(), responseObserver);
    }

    /**
     * <pre>
     * Lookup a transaction tree by its ID.
     * For looking up a transaction instead of a transaction tree, please see GetFlatTransactionById
     * </pre>
     */
    public void getTransactionById(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetTransactionByIdMethod(), responseObserver);
    }

    /**
     * <pre>
     * Lookup a transaction by the ID of an event that appears within it.
     * </pre>
     */
    public void getFlatTransactionByEventId(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetFlatTransactionByEventIdMethod(), responseObserver);
    }

    /**
     * <pre>
     * Lookup a transaction by its ID.
     * </pre>
     */
    public void getFlatTransactionById(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetFlatTransactionByIdMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get the current ledger end.
     * Subscriptions started with the returned offset will serve transactions created after this RPC was called.
     * </pre>
     */
    public void getLedgerEnd(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetLedgerEndMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetTransactionsMethod(),
            io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest,
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsResponse>(
                  this, METHODID_GET_TRANSACTIONS)))
          .addMethod(
            getGetTransactionTreesMethod(),
            io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest,
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionTreesResponse>(
                  this, METHODID_GET_TRANSACTION_TREES)))
          .addMethod(
            getGetTransactionByEventIdMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest,
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse>(
                  this, METHODID_GET_TRANSACTION_BY_EVENT_ID)))
          .addMethod(
            getGetTransactionByIdMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest,
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse>(
                  this, METHODID_GET_TRANSACTION_BY_ID)))
          .addMethod(
            getGetFlatTransactionByEventIdMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest,
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse>(
                  this, METHODID_GET_FLAT_TRANSACTION_BY_EVENT_ID)))
          .addMethod(
            getGetFlatTransactionByIdMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest,
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse>(
                  this, METHODID_GET_FLAT_TRANSACTION_BY_ID)))
          .addMethod(
            getGetLedgerEndMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest,
                com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse>(
                  this, METHODID_GET_LEDGER_END)))
          .build();
    }
  }

  /**
   * <pre>
   * Allows clients to read transactions from the ledger.
   * </pre>
   */
  public static final class TransactionServiceStub extends io.grpc.stub.AbstractAsyncStub<TransactionServiceStub> {
    private TransactionServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TransactionServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TransactionServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Read the ledger's filtered transaction stream for a set of parties.
     * Lists only creates and archives, but not other events.
     * Omits all events on transient contracts, i.e., contracts that were both created and archived in the same transaction.
     * </pre>
     */
    public void getTransactions(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getGetTransactionsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Read the ledger's complete transaction tree stream for a set of parties.
     * The stream can be filtered only by parties, but not templates (template filter must be empty).
     * </pre>
     */
    public void getTransactionTrees(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionTreesResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getGetTransactionTreesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Lookup a transaction tree by the ID of an event that appears within it.
     * For looking up a transaction instead of a transaction tree, please see GetFlatTransactionByEventId
     * </pre>
     */
    public void getTransactionByEventId(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetTransactionByEventIdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Lookup a transaction tree by its ID.
     * For looking up a transaction instead of a transaction tree, please see GetFlatTransactionById
     * </pre>
     */
    public void getTransactionById(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetTransactionByIdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Lookup a transaction by the ID of an event that appears within it.
     * </pre>
     */
    public void getFlatTransactionByEventId(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetFlatTransactionByEventIdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Lookup a transaction by its ID.
     * </pre>
     */
    public void getFlatTransactionById(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetFlatTransactionByIdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get the current ledger end.
     * Subscriptions started with the returned offset will serve transactions created after this RPC was called.
     * </pre>
     */
    public void getLedgerEnd(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetLedgerEndMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Allows clients to read transactions from the ledger.
   * </pre>
   */
  public static final class TransactionServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<TransactionServiceBlockingStub> {
    private TransactionServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TransactionServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TransactionServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Read the ledger's filtered transaction stream for a set of parties.
     * Lists only creates and archives, but not other events.
     * Omits all events on transient contracts, i.e., contracts that were both created and archived in the same transaction.
     * </pre>
     */
    public java.util.Iterator<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsResponse> getTransactions(
        com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getGetTransactionsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Read the ledger's complete transaction tree stream for a set of parties.
     * The stream can be filtered only by parties, but not templates (template filter must be empty).
     * </pre>
     */
    public java.util.Iterator<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionTreesResponse> getTransactionTrees(
        com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getGetTransactionTreesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Lookup a transaction tree by the ID of an event that appears within it.
     * For looking up a transaction instead of a transaction tree, please see GetFlatTransactionByEventId
     * </pre>
     */
    public com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse getTransactionByEventId(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetTransactionByEventIdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Lookup a transaction tree by its ID.
     * For looking up a transaction instead of a transaction tree, please see GetFlatTransactionById
     * </pre>
     */
    public com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse getTransactionById(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetTransactionByIdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Lookup a transaction by the ID of an event that appears within it.
     * </pre>
     */
    public com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse getFlatTransactionByEventId(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetFlatTransactionByEventIdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Lookup a transaction by its ID.
     * </pre>
     */
    public com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse getFlatTransactionById(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetFlatTransactionByIdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get the current ledger end.
     * Subscriptions started with the returned offset will serve transactions created after this RPC was called.
     * </pre>
     */
    public com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse getLedgerEnd(com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetLedgerEndMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Allows clients to read transactions from the ledger.
   * </pre>
   */
  public static final class TransactionServiceFutureStub extends io.grpc.stub.AbstractFutureStub<TransactionServiceFutureStub> {
    private TransactionServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TransactionServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TransactionServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lookup a transaction tree by the ID of an event that appears within it.
     * For looking up a transaction instead of a transaction tree, please see GetFlatTransactionByEventId
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> getTransactionByEventId(
        com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetTransactionByEventIdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Lookup a transaction tree by its ID.
     * For looking up a transaction instead of a transaction tree, please see GetFlatTransactionById
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse> getTransactionById(
        com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetTransactionByIdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Lookup a transaction by the ID of an event that appears within it.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> getFlatTransactionByEventId(
        com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetFlatTransactionByEventIdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Lookup a transaction by its ID.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse> getFlatTransactionById(
        com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetFlatTransactionByIdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get the current ledger end.
     * Subscriptions started with the returned offset will serve transactions created after this RPC was called.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse> getLedgerEnd(
        com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetLedgerEndMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_TRANSACTIONS = 0;
  private static final int METHODID_GET_TRANSACTION_TREES = 1;
  private static final int METHODID_GET_TRANSACTION_BY_EVENT_ID = 2;
  private static final int METHODID_GET_TRANSACTION_BY_ID = 3;
  private static final int METHODID_GET_FLAT_TRANSACTION_BY_EVENT_ID = 4;
  private static final int METHODID_GET_FLAT_TRANSACTION_BY_ID = 5;
  private static final int METHODID_GET_LEDGER_END = 6;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final TransactionServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(TransactionServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_TRANSACTIONS:
          serviceImpl.getTransactions((com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsResponse>) responseObserver);
          break;
        case METHODID_GET_TRANSACTION_TREES:
          serviceImpl.getTransactionTrees((com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionsRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionTreesResponse>) responseObserver);
          break;
        case METHODID_GET_TRANSACTION_BY_EVENT_ID:
          serviceImpl.getTransactionByEventId((com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse>) responseObserver);
          break;
        case METHODID_GET_TRANSACTION_BY_ID:
          serviceImpl.getTransactionById((com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionResponse>) responseObserver);
          break;
        case METHODID_GET_FLAT_TRANSACTION_BY_EVENT_ID:
          serviceImpl.getFlatTransactionByEventId((com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByEventIdRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse>) responseObserver);
          break;
        case METHODID_GET_FLAT_TRANSACTION_BY_ID:
          serviceImpl.getFlatTransactionById((com.daml.ledger.api.v1.TransactionServiceOuterClass.GetTransactionByIdRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetFlatTransactionResponse>) responseObserver);
          break;
        case METHODID_GET_LEDGER_END:
          serviceImpl.getLedgerEnd((com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.TransactionServiceOuterClass.GetLedgerEndResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class TransactionServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    TransactionServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.TransactionServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("TransactionService");
    }
  }

  private static final class TransactionServiceFileDescriptorSupplier
      extends TransactionServiceBaseDescriptorSupplier {
    TransactionServiceFileDescriptorSupplier() {}
  }

  private static final class TransactionServiceMethodDescriptorSupplier
      extends TransactionServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    TransactionServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (TransactionServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new TransactionServiceFileDescriptorSupplier())
              .addMethod(getGetTransactionsMethod())
              .addMethod(getGetTransactionTreesMethod())
              .addMethod(getGetTransactionByEventIdMethod())
              .addMethod(getGetTransactionByIdMethod())
              .addMethod(getGetFlatTransactionByEventIdMethod())
              .addMethod(getGetFlatTransactionByIdMethod())
              .addMethod(getGetLedgerEndMethod())
              .build();
        }
      }
    }
    return result;
  }
}
