package com.daml.ledger.api.v1.admin;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Prunes/truncates the "oldest" transactions from the participant (the participant Ledger Api Server plus any other
 * participant-local state) by removing a portion of the ledger in such a way that the set of future, allowed
 * commands are not affected.
 * This enables:
 * 1. keeping the "inactive" portion of the ledger to a manageable size and
 * 2. removing inactive state to honor the right to be forgotten.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/admin/participant_pruning_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class ParticipantPruningServiceGrpc {

  private ParticipantPruningServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.admin.ParticipantPruningService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest,
      com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse> getPruneMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Prune",
      requestType = com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest.class,
      responseType = com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest,
      com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse> getPruneMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest, com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse> getPruneMethod;
    if ((getPruneMethod = ParticipantPruningServiceGrpc.getPruneMethod) == null) {
      synchronized (ParticipantPruningServiceGrpc.class) {
        if ((getPruneMethod = ParticipantPruningServiceGrpc.getPruneMethod) == null) {
          ParticipantPruningServiceGrpc.getPruneMethod = getPruneMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest, com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Prune"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ParticipantPruningServiceMethodDescriptorSupplier("Prune"))
              .build();
        }
      }
    }
    return getPruneMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ParticipantPruningServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<ParticipantPruningServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<ParticipantPruningServiceStub>() {
        @java.lang.Override
        public ParticipantPruningServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new ParticipantPruningServiceStub(channel, callOptions);
        }
      };
    return ParticipantPruningServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ParticipantPruningServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<ParticipantPruningServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<ParticipantPruningServiceBlockingStub>() {
        @java.lang.Override
        public ParticipantPruningServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new ParticipantPruningServiceBlockingStub(channel, callOptions);
        }
      };
    return ParticipantPruningServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static ParticipantPruningServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<ParticipantPruningServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<ParticipantPruningServiceFutureStub>() {
        @java.lang.Override
        public ParticipantPruningServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new ParticipantPruningServiceFutureStub(channel, callOptions);
        }
      };
    return ParticipantPruningServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Prunes/truncates the "oldest" transactions from the participant (the participant Ledger Api Server plus any other
   * participant-local state) by removing a portion of the ledger in such a way that the set of future, allowed
   * commands are not affected.
   * This enables:
   * 1. keeping the "inactive" portion of the ledger to a manageable size and
   * 2. removing inactive state to honor the right to be forgotten.
   * </pre>
   */
  public static abstract class ParticipantPruningServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Prune the ledger specifying the offset before and at which ledger transactions should be removed. Only returns when
     * the potentially long-running prune request ends successfully or with an error.
     * </pre>
     */
    public void prune(com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPruneMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getPruneMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest,
                com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse>(
                  this, METHODID_PRUNE)))
          .build();
    }
  }

  /**
   * <pre>
   * Prunes/truncates the "oldest" transactions from the participant (the participant Ledger Api Server plus any other
   * participant-local state) by removing a portion of the ledger in such a way that the set of future, allowed
   * commands are not affected.
   * This enables:
   * 1. keeping the "inactive" portion of the ledger to a manageable size and
   * 2. removing inactive state to honor the right to be forgotten.
   * </pre>
   */
  public static final class ParticipantPruningServiceStub extends io.grpc.stub.AbstractAsyncStub<ParticipantPruningServiceStub> {
    private ParticipantPruningServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ParticipantPruningServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new ParticipantPruningServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Prune the ledger specifying the offset before and at which ledger transactions should be removed. Only returns when
     * the potentially long-running prune request ends successfully or with an error.
     * </pre>
     */
    public void prune(com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPruneMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Prunes/truncates the "oldest" transactions from the participant (the participant Ledger Api Server plus any other
   * participant-local state) by removing a portion of the ledger in such a way that the set of future, allowed
   * commands are not affected.
   * This enables:
   * 1. keeping the "inactive" portion of the ledger to a manageable size and
   * 2. removing inactive state to honor the right to be forgotten.
   * </pre>
   */
  public static final class ParticipantPruningServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<ParticipantPruningServiceBlockingStub> {
    private ParticipantPruningServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ParticipantPruningServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new ParticipantPruningServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Prune the ledger specifying the offset before and at which ledger transactions should be removed. Only returns when
     * the potentially long-running prune request ends successfully or with an error.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse prune(com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPruneMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Prunes/truncates the "oldest" transactions from the participant (the participant Ledger Api Server plus any other
   * participant-local state) by removing a portion of the ledger in such a way that the set of future, allowed
   * commands are not affected.
   * This enables:
   * 1. keeping the "inactive" portion of the ledger to a manageable size and
   * 2. removing inactive state to honor the right to be forgotten.
   * </pre>
   */
  public static final class ParticipantPruningServiceFutureStub extends io.grpc.stub.AbstractFutureStub<ParticipantPruningServiceFutureStub> {
    private ParticipantPruningServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ParticipantPruningServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new ParticipantPruningServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Prune the ledger specifying the offset before and at which ledger transactions should be removed. Only returns when
     * the potentially long-running prune request ends successfully or with an error.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse> prune(
        com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPruneMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_PRUNE = 0;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final ParticipantPruningServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(ParticipantPruningServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PRUNE:
          serviceImpl.prune((com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.PruneResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class ParticipantPruningServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    ParticipantPruningServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.admin.ParticipantPruningServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("ParticipantPruningService");
    }
  }

  private static final class ParticipantPruningServiceFileDescriptorSupplier
      extends ParticipantPruningServiceBaseDescriptorSupplier {
    ParticipantPruningServiceFileDescriptorSupplier() {}
  }

  private static final class ParticipantPruningServiceMethodDescriptorSupplier
      extends ParticipantPruningServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    ParticipantPruningServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ParticipantPruningServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ParticipantPruningServiceFileDescriptorSupplier())
              .addMethod(getPruneMethod())
              .build();
        }
      }
    }
    return result;
  }
}
