package com.daml.ledger.api.v1.admin;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Service to manage users and their rights for interacting with the Ledger API
 * served by a participant node.
 * The authorization rules for its RPCs are specified on the ``&lt;RpcName&gt;Request``
 * messages as boolean expressions over these two facts:
 * (1) ``HasRight(r)`` denoting whether the authenticated user has right ``r`` and
 * (2) ``IsAuthenticatedUser(uid)`` denoting whether ``uid`` is the empty string or equal to the id of the authenticated user.
 * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
 * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
 * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
 * A user resource consists of:
 * (1) a set of properties represented by the ``User`` message,
 * (2) a set of user rights, where each right is represented by the ``Right`` message.
 * A user resource, once it has been created, can be modified.
 * In order to update the properties represented by the ``User`` message use the ``UpdateUser`` RPC. The only fields that can be modified are those marked as ``Modifiable``.
 * In order to grant or revoke user rights use ``GrantRights' and ``RevokeRights`` RPCs.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/admin/user_management_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class UserManagementServiceGrpc {

  private UserManagementServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.admin.UserManagementService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse> getCreateUserMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateUser",
      requestType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest.class,
      responseType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse> getCreateUserMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse> getCreateUserMethod;
    if ((getCreateUserMethod = UserManagementServiceGrpc.getCreateUserMethod) == null) {
      synchronized (UserManagementServiceGrpc.class) {
        if ((getCreateUserMethod = UserManagementServiceGrpc.getCreateUserMethod) == null) {
          UserManagementServiceGrpc.getCreateUserMethod = getCreateUserMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateUser"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse.getDefaultInstance()))
              .setSchemaDescriptor(new UserManagementServiceMethodDescriptorSupplier("CreateUser"))
              .build();
        }
      }
    }
    return getCreateUserMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse> getGetUserMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetUser",
      requestType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest.class,
      responseType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse> getGetUserMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse> getGetUserMethod;
    if ((getGetUserMethod = UserManagementServiceGrpc.getGetUserMethod) == null) {
      synchronized (UserManagementServiceGrpc.class) {
        if ((getGetUserMethod = UserManagementServiceGrpc.getGetUserMethod) == null) {
          UserManagementServiceGrpc.getGetUserMethod = getGetUserMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetUser"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse.getDefaultInstance()))
              .setSchemaDescriptor(new UserManagementServiceMethodDescriptorSupplier("GetUser"))
              .build();
        }
      }
    }
    return getGetUserMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse> getUpdateUserMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UpdateUser",
      requestType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest.class,
      responseType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse> getUpdateUserMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse> getUpdateUserMethod;
    if ((getUpdateUserMethod = UserManagementServiceGrpc.getUpdateUserMethod) == null) {
      synchronized (UserManagementServiceGrpc.class) {
        if ((getUpdateUserMethod = UserManagementServiceGrpc.getUpdateUserMethod) == null) {
          UserManagementServiceGrpc.getUpdateUserMethod = getUpdateUserMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "UpdateUser"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse.getDefaultInstance()))
              .setSchemaDescriptor(new UserManagementServiceMethodDescriptorSupplier("UpdateUser"))
              .build();
        }
      }
    }
    return getUpdateUserMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse> getDeleteUserMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteUser",
      requestType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest.class,
      responseType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse> getDeleteUserMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse> getDeleteUserMethod;
    if ((getDeleteUserMethod = UserManagementServiceGrpc.getDeleteUserMethod) == null) {
      synchronized (UserManagementServiceGrpc.class) {
        if ((getDeleteUserMethod = UserManagementServiceGrpc.getDeleteUserMethod) == null) {
          UserManagementServiceGrpc.getDeleteUserMethod = getDeleteUserMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteUser"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse.getDefaultInstance()))
              .setSchemaDescriptor(new UserManagementServiceMethodDescriptorSupplier("DeleteUser"))
              .build();
        }
      }
    }
    return getDeleteUserMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse> getListUsersMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListUsers",
      requestType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest.class,
      responseType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse> getListUsersMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse> getListUsersMethod;
    if ((getListUsersMethod = UserManagementServiceGrpc.getListUsersMethod) == null) {
      synchronized (UserManagementServiceGrpc.class) {
        if ((getListUsersMethod = UserManagementServiceGrpc.getListUsersMethod) == null) {
          UserManagementServiceGrpc.getListUsersMethod = getListUsersMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListUsers"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse.getDefaultInstance()))
              .setSchemaDescriptor(new UserManagementServiceMethodDescriptorSupplier("ListUsers"))
              .build();
        }
      }
    }
    return getListUsersMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse> getGrantUserRightsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GrantUserRights",
      requestType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest.class,
      responseType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse> getGrantUserRightsMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse> getGrantUserRightsMethod;
    if ((getGrantUserRightsMethod = UserManagementServiceGrpc.getGrantUserRightsMethod) == null) {
      synchronized (UserManagementServiceGrpc.class) {
        if ((getGrantUserRightsMethod = UserManagementServiceGrpc.getGrantUserRightsMethod) == null) {
          UserManagementServiceGrpc.getGrantUserRightsMethod = getGrantUserRightsMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GrantUserRights"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new UserManagementServiceMethodDescriptorSupplier("GrantUserRights"))
              .build();
        }
      }
    }
    return getGrantUserRightsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse> getRevokeUserRightsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RevokeUserRights",
      requestType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest.class,
      responseType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse> getRevokeUserRightsMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse> getRevokeUserRightsMethod;
    if ((getRevokeUserRightsMethod = UserManagementServiceGrpc.getRevokeUserRightsMethod) == null) {
      synchronized (UserManagementServiceGrpc.class) {
        if ((getRevokeUserRightsMethod = UserManagementServiceGrpc.getRevokeUserRightsMethod) == null) {
          UserManagementServiceGrpc.getRevokeUserRightsMethod = getRevokeUserRightsMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RevokeUserRights"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new UserManagementServiceMethodDescriptorSupplier("RevokeUserRights"))
              .build();
        }
      }
    }
    return getRevokeUserRightsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse> getListUserRightsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListUserRights",
      requestType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest.class,
      responseType = com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest,
      com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse> getListUserRightsMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse> getListUserRightsMethod;
    if ((getListUserRightsMethod = UserManagementServiceGrpc.getListUserRightsMethod) == null) {
      synchronized (UserManagementServiceGrpc.class) {
        if ((getListUserRightsMethod = UserManagementServiceGrpc.getListUserRightsMethod) == null) {
          UserManagementServiceGrpc.getListUserRightsMethod = getListUserRightsMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest, com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListUserRights"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new UserManagementServiceMethodDescriptorSupplier("ListUserRights"))
              .build();
        }
      }
    }
    return getListUserRightsMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static UserManagementServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<UserManagementServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<UserManagementServiceStub>() {
        @java.lang.Override
        public UserManagementServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new UserManagementServiceStub(channel, callOptions);
        }
      };
    return UserManagementServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static UserManagementServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<UserManagementServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<UserManagementServiceBlockingStub>() {
        @java.lang.Override
        public UserManagementServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new UserManagementServiceBlockingStub(channel, callOptions);
        }
      };
    return UserManagementServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static UserManagementServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<UserManagementServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<UserManagementServiceFutureStub>() {
        @java.lang.Override
        public UserManagementServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new UserManagementServiceFutureStub(channel, callOptions);
        }
      };
    return UserManagementServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Service to manage users and their rights for interacting with the Ledger API
   * served by a participant node.
   * The authorization rules for its RPCs are specified on the ``&lt;RpcName&gt;Request``
   * messages as boolean expressions over these two facts:
   * (1) ``HasRight(r)`` denoting whether the authenticated user has right ``r`` and
   * (2) ``IsAuthenticatedUser(uid)`` denoting whether ``uid`` is the empty string or equal to the id of the authenticated user.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * A user resource consists of:
   * (1) a set of properties represented by the ``User`` message,
   * (2) a set of user rights, where each right is represented by the ``Right`` message.
   * A user resource, once it has been created, can be modified.
   * In order to update the properties represented by the ``User`` message use the ``UpdateUser`` RPC. The only fields that can be modified are those marked as ``Modifiable``.
   * In order to grant or revoke user rights use ``GrantRights' and ``RevokeRights`` RPCs.
   * </pre>
   */
  public static abstract class UserManagementServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Create a new user.
     * </pre>
     */
    public void createUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCreateUserMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get the user data of a specific user or the authenticated user.
     * </pre>
     */
    public void getUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetUserMethod(), responseObserver);
    }

    /**
     * <pre>
     * Update selected modifiable attribute of a user resource described by the ``User`` message.
     * </pre>
     */
    public void updateUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdateUserMethod(), responseObserver);
    }

    /**
     * <pre>
     * Delete an existing user and all its rights.
     * </pre>
     */
    public void deleteUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getDeleteUserMethod(), responseObserver);
    }

    /**
     * <pre>
     * List all existing users.
     * </pre>
     */
    public void listUsers(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListUsersMethod(), responseObserver);
    }

    /**
     * <pre>
     * Grant rights to a user.
     * Granting rights does not affect the resource version of the corresponding user.
     * </pre>
     */
    public void grantUserRights(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGrantUserRightsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Revoke rights from a user.
     * Revoking rights does not affect the resource version of the corresponding user.
     * </pre>
     */
    public void revokeUserRights(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRevokeUserRightsMethod(), responseObserver);
    }

    /**
     * <pre>
     * List the set of all rights granted to a user.
     * </pre>
     */
    public void listUserRights(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListUserRightsMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getCreateUserMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest,
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse>(
                  this, METHODID_CREATE_USER)))
          .addMethod(
            getGetUserMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest,
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse>(
                  this, METHODID_GET_USER)))
          .addMethod(
            getUpdateUserMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest,
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse>(
                  this, METHODID_UPDATE_USER)))
          .addMethod(
            getDeleteUserMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest,
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse>(
                  this, METHODID_DELETE_USER)))
          .addMethod(
            getListUsersMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest,
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse>(
                  this, METHODID_LIST_USERS)))
          .addMethod(
            getGrantUserRightsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest,
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse>(
                  this, METHODID_GRANT_USER_RIGHTS)))
          .addMethod(
            getRevokeUserRightsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest,
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse>(
                  this, METHODID_REVOKE_USER_RIGHTS)))
          .addMethod(
            getListUserRightsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest,
                com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse>(
                  this, METHODID_LIST_USER_RIGHTS)))
          .build();
    }
  }

  /**
   * <pre>
   * Service to manage users and their rights for interacting with the Ledger API
   * served by a participant node.
   * The authorization rules for its RPCs are specified on the ``&lt;RpcName&gt;Request``
   * messages as boolean expressions over these two facts:
   * (1) ``HasRight(r)`` denoting whether the authenticated user has right ``r`` and
   * (2) ``IsAuthenticatedUser(uid)`` denoting whether ``uid`` is the empty string or equal to the id of the authenticated user.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * A user resource consists of:
   * (1) a set of properties represented by the ``User`` message,
   * (2) a set of user rights, where each right is represented by the ``Right`` message.
   * A user resource, once it has been created, can be modified.
   * In order to update the properties represented by the ``User`` message use the ``UpdateUser`` RPC. The only fields that can be modified are those marked as ``Modifiable``.
   * In order to grant or revoke user rights use ``GrantRights' and ``RevokeRights`` RPCs.
   * </pre>
   */
  public static final class UserManagementServiceStub extends io.grpc.stub.AbstractAsyncStub<UserManagementServiceStub> {
    private UserManagementServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected UserManagementServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new UserManagementServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Create a new user.
     * </pre>
     */
    public void createUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCreateUserMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get the user data of a specific user or the authenticated user.
     * </pre>
     */
    public void getUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetUserMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Update selected modifiable attribute of a user resource described by the ``User`` message.
     * </pre>
     */
    public void updateUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdateUserMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Delete an existing user and all its rights.
     * </pre>
     */
    public void deleteUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getDeleteUserMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * List all existing users.
     * </pre>
     */
    public void listUsers(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListUsersMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Grant rights to a user.
     * Granting rights does not affect the resource version of the corresponding user.
     * </pre>
     */
    public void grantUserRights(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGrantUserRightsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Revoke rights from a user.
     * Revoking rights does not affect the resource version of the corresponding user.
     * </pre>
     */
    public void revokeUserRights(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRevokeUserRightsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * List the set of all rights granted to a user.
     * </pre>
     */
    public void listUserRights(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListUserRightsMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Service to manage users and their rights for interacting with the Ledger API
   * served by a participant node.
   * The authorization rules for its RPCs are specified on the ``&lt;RpcName&gt;Request``
   * messages as boolean expressions over these two facts:
   * (1) ``HasRight(r)`` denoting whether the authenticated user has right ``r`` and
   * (2) ``IsAuthenticatedUser(uid)`` denoting whether ``uid`` is the empty string or equal to the id of the authenticated user.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * A user resource consists of:
   * (1) a set of properties represented by the ``User`` message,
   * (2) a set of user rights, where each right is represented by the ``Right`` message.
   * A user resource, once it has been created, can be modified.
   * In order to update the properties represented by the ``User`` message use the ``UpdateUser`` RPC. The only fields that can be modified are those marked as ``Modifiable``.
   * In order to grant or revoke user rights use ``GrantRights' and ``RevokeRights`` RPCs.
   * </pre>
   */
  public static final class UserManagementServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<UserManagementServiceBlockingStub> {
    private UserManagementServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected UserManagementServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new UserManagementServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Create a new user.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse createUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCreateUserMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get the user data of a specific user or the authenticated user.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse getUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetUserMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Update selected modifiable attribute of a user resource described by the ``User`` message.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse updateUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdateUserMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Delete an existing user and all its rights.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse deleteUser(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getDeleteUserMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * List all existing users.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse listUsers(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListUsersMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Grant rights to a user.
     * Granting rights does not affect the resource version of the corresponding user.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse grantUserRights(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGrantUserRightsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Revoke rights from a user.
     * Revoking rights does not affect the resource version of the corresponding user.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse revokeUserRights(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRevokeUserRightsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * List the set of all rights granted to a user.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse listUserRights(com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListUserRightsMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Service to manage users and their rights for interacting with the Ledger API
   * served by a participant node.
   * The authorization rules for its RPCs are specified on the ``&lt;RpcName&gt;Request``
   * messages as boolean expressions over these two facts:
   * (1) ``HasRight(r)`` denoting whether the authenticated user has right ``r`` and
   * (2) ``IsAuthenticatedUser(uid)`` denoting whether ``uid`` is the empty string or equal to the id of the authenticated user.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * A user resource consists of:
   * (1) a set of properties represented by the ``User`` message,
   * (2) a set of user rights, where each right is represented by the ``Right`` message.
   * A user resource, once it has been created, can be modified.
   * In order to update the properties represented by the ``User`` message use the ``UpdateUser`` RPC. The only fields that can be modified are those marked as ``Modifiable``.
   * In order to grant or revoke user rights use ``GrantRights' and ``RevokeRights`` RPCs.
   * </pre>
   */
  public static final class UserManagementServiceFutureStub extends io.grpc.stub.AbstractFutureStub<UserManagementServiceFutureStub> {
    private UserManagementServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected UserManagementServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new UserManagementServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Create a new user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse> createUser(
        com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCreateUserMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get the user data of a specific user or the authenticated user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse> getUser(
        com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetUserMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Update selected modifiable attribute of a user resource described by the ``User`` message.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse> updateUser(
        com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdateUserMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Delete an existing user and all its rights.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse> deleteUser(
        com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getDeleteUserMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * List all existing users.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse> listUsers(
        com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListUsersMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Grant rights to a user.
     * Granting rights does not affect the resource version of the corresponding user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse> grantUserRights(
        com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGrantUserRightsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Revoke rights from a user.
     * Revoking rights does not affect the resource version of the corresponding user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse> revokeUserRights(
        com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRevokeUserRightsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * List the set of all rights granted to a user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse> listUserRights(
        com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListUserRightsMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_CREATE_USER = 0;
  private static final int METHODID_GET_USER = 1;
  private static final int METHODID_UPDATE_USER = 2;
  private static final int METHODID_DELETE_USER = 3;
  private static final int METHODID_LIST_USERS = 4;
  private static final int METHODID_GRANT_USER_RIGHTS = 5;
  private static final int METHODID_REVOKE_USER_RIGHTS = 6;
  private static final int METHODID_LIST_USER_RIGHTS = 7;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final UserManagementServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(UserManagementServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_CREATE_USER:
          serviceImpl.createUser((com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.CreateUserResponse>) responseObserver);
          break;
        case METHODID_GET_USER:
          serviceImpl.getUser((com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GetUserResponse>) responseObserver);
          break;
        case METHODID_UPDATE_USER:
          serviceImpl.updateUser((com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.UpdateUserResponse>) responseObserver);
          break;
        case METHODID_DELETE_USER:
          serviceImpl.deleteUser((com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.DeleteUserResponse>) responseObserver);
          break;
        case METHODID_LIST_USERS:
          serviceImpl.listUsers((com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUsersResponse>) responseObserver);
          break;
        case METHODID_GRANT_USER_RIGHTS:
          serviceImpl.grantUserRights((com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.GrantUserRightsResponse>) responseObserver);
          break;
        case METHODID_REVOKE_USER_RIGHTS:
          serviceImpl.revokeUserRights((com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.RevokeUserRightsResponse>) responseObserver);
          break;
        case METHODID_LIST_USER_RIGHTS:
          serviceImpl.listUserRights((com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.ListUserRightsResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class UserManagementServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    UserManagementServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("UserManagementService");
    }
  }

  private static final class UserManagementServiceFileDescriptorSupplier
      extends UserManagementServiceBaseDescriptorSupplier {
    UserManagementServiceFileDescriptorSupplier() {}
  }

  private static final class UserManagementServiceMethodDescriptorSupplier
      extends UserManagementServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    UserManagementServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (UserManagementServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new UserManagementServiceFileDescriptorSupplier())
              .addMethod(getCreateUserMethod())
              .addMethod(getGetUserMethod())
              .addMethod(getUpdateUserMethod())
              .addMethod(getDeleteUserMethod())
              .addMethod(getListUsersMethod())
              .addMethod(getGrantUserRightsMethod())
              .addMethod(getRevokeUserRightsMethod())
              .addMethod(getListUserRightsMethod())
              .build();
        }
      }
    }
    return result;
  }
}
