/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.Event;
import com.daml.ledger.javaapi.data.ExercisedEvent;
import com.daml.ledger.javaapi.data.TransactionTree;
import java.util.List;
import java.util.Optional;

public class EventUtils {
    private EventUtils() {
    }

    public static CreatedEvent singleCreatedEvent(List<? extends Event> events) {
        if (events.size() == 1 && events.get(0) instanceof CreatedEvent) {
            return (CreatedEvent)events.get(0);
        }
        throw new IllegalArgumentException("Expected exactly one created event from the transaction, got: " + events);
    }

    public static ExercisedEvent firstExercisedEvent(TransactionTree txTree) {
        Optional<ExercisedEvent> maybeExercisedEvent = txTree.getRootEventIds().stream().map(eventId -> txTree.getEventsById().get(eventId)).filter(e -> e instanceof ExercisedEvent).map(e -> (ExercisedEvent)e).findFirst();
        return maybeExercisedEvent.orElseThrow(() -> new IllegalArgumentException("Expect an exercised event but not found. tx: " + txTree));
    }
}

