package com.daml.ledger.api.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Allows clients to initialize themselves according to a fairly recent state of the ledger without reading through all transactions that were committed since the ledger's creation.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/active_contracts_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class ActiveContractsServiceGrpc {

  private ActiveContractsServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.ActiveContractsService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsRequest,
      com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsResponse> getGetActiveContractsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetActiveContracts",
      requestType = com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsRequest.class,
      responseType = com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsRequest,
      com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsResponse> getGetActiveContractsMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsRequest, com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsResponse> getGetActiveContractsMethod;
    if ((getGetActiveContractsMethod = ActiveContractsServiceGrpc.getGetActiveContractsMethod) == null) {
      synchronized (ActiveContractsServiceGrpc.class) {
        if ((getGetActiveContractsMethod = ActiveContractsServiceGrpc.getGetActiveContractsMethod) == null) {
          ActiveContractsServiceGrpc.getGetActiveContractsMethod = getGetActiveContractsMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsRequest, com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetActiveContracts"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ActiveContractsServiceMethodDescriptorSupplier("GetActiveContracts"))
              .build();
        }
      }
    }
    return getGetActiveContractsMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ActiveContractsServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<ActiveContractsServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<ActiveContractsServiceStub>() {
        @java.lang.Override
        public ActiveContractsServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new ActiveContractsServiceStub(channel, callOptions);
        }
      };
    return ActiveContractsServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ActiveContractsServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<ActiveContractsServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<ActiveContractsServiceBlockingStub>() {
        @java.lang.Override
        public ActiveContractsServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new ActiveContractsServiceBlockingStub(channel, callOptions);
        }
      };
    return ActiveContractsServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static ActiveContractsServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<ActiveContractsServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<ActiveContractsServiceFutureStub>() {
        @java.lang.Override
        public ActiveContractsServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new ActiveContractsServiceFutureStub(channel, callOptions);
        }
      };
    return ActiveContractsServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Allows clients to initialize themselves according to a fairly recent state of the ledger without reading through all transactions that were committed since the ledger's creation.
   * </pre>
   */
  public static abstract class ActiveContractsServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Returns a stream of the snapshot of the active contracts at a ledger offset.
     * If there are no active contracts, the stream returns a single response message with the offset at which the snapshot has been taken.
     * Clients SHOULD use the offset in the last GetActiveContractsResponse message to continue streaming transactions with the transaction service.
     * Clients SHOULD NOT assume that the set of active contracts they receive reflects the state at the ledger end.
     * </pre>
     */
    public void getActiveContracts(com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetActiveContractsMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetActiveContractsMethod(),
            io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsRequest,
                com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsResponse>(
                  this, METHODID_GET_ACTIVE_CONTRACTS)))
          .build();
    }
  }

  /**
   * <pre>
   * Allows clients to initialize themselves according to a fairly recent state of the ledger without reading through all transactions that were committed since the ledger's creation.
   * </pre>
   */
  public static final class ActiveContractsServiceStub extends io.grpc.stub.AbstractAsyncStub<ActiveContractsServiceStub> {
    private ActiveContractsServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ActiveContractsServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new ActiveContractsServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns a stream of the snapshot of the active contracts at a ledger offset.
     * If there are no active contracts, the stream returns a single response message with the offset at which the snapshot has been taken.
     * Clients SHOULD use the offset in the last GetActiveContractsResponse message to continue streaming transactions with the transaction service.
     * Clients SHOULD NOT assume that the set of active contracts they receive reflects the state at the ledger end.
     * </pre>
     */
    public void getActiveContracts(com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getGetActiveContractsMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Allows clients to initialize themselves according to a fairly recent state of the ledger without reading through all transactions that were committed since the ledger's creation.
   * </pre>
   */
  public static final class ActiveContractsServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<ActiveContractsServiceBlockingStub> {
    private ActiveContractsServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ActiveContractsServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new ActiveContractsServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns a stream of the snapshot of the active contracts at a ledger offset.
     * If there are no active contracts, the stream returns a single response message with the offset at which the snapshot has been taken.
     * Clients SHOULD use the offset in the last GetActiveContractsResponse message to continue streaming transactions with the transaction service.
     * Clients SHOULD NOT assume that the set of active contracts they receive reflects the state at the ledger end.
     * </pre>
     */
    public java.util.Iterator<com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsResponse> getActiveContracts(
        com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getGetActiveContractsMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Allows clients to initialize themselves according to a fairly recent state of the ledger without reading through all transactions that were committed since the ledger's creation.
   * </pre>
   */
  public static final class ActiveContractsServiceFutureStub extends io.grpc.stub.AbstractFutureStub<ActiveContractsServiceFutureStub> {
    private ActiveContractsServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ActiveContractsServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new ActiveContractsServiceFutureStub(channel, callOptions);
    }
  }

  private static final int METHODID_GET_ACTIVE_CONTRACTS = 0;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final ActiveContractsServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(ActiveContractsServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_ACTIVE_CONTRACTS:
          serviceImpl.getActiveContracts((com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.GetActiveContractsResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class ActiveContractsServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    ActiveContractsServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.ActiveContractsServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("ActiveContractsService");
    }
  }

  private static final class ActiveContractsServiceFileDescriptorSupplier
      extends ActiveContractsServiceBaseDescriptorSupplier {
    ActiveContractsServiceFileDescriptorSupplier() {}
  }

  private static final class ActiveContractsServiceMethodDescriptorSupplier
      extends ActiveContractsServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    ActiveContractsServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ActiveContractsServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ActiveContractsServiceFileDescriptorSupplier())
              .addMethod(getGetActiveContractsMethod())
              .build();
        }
      }
    }
    return result;
  }
}
