package com.daml.ledger.api.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Query events by contract id or key.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/event_query_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class EventQueryServiceGrpc {

  private EventQueryServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.EventQueryService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest,
      com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse> getGetEventsByContractIdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetEventsByContractId",
      requestType = com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest.class,
      responseType = com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest,
      com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse> getGetEventsByContractIdMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest, com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse> getGetEventsByContractIdMethod;
    if ((getGetEventsByContractIdMethod = EventQueryServiceGrpc.getGetEventsByContractIdMethod) == null) {
      synchronized (EventQueryServiceGrpc.class) {
        if ((getGetEventsByContractIdMethod = EventQueryServiceGrpc.getGetEventsByContractIdMethod) == null) {
          EventQueryServiceGrpc.getGetEventsByContractIdMethod = getGetEventsByContractIdMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest, com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetEventsByContractId"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse.getDefaultInstance()))
              .setSchemaDescriptor(new EventQueryServiceMethodDescriptorSupplier("GetEventsByContractId"))
              .build();
        }
      }
    }
    return getGetEventsByContractIdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest,
      com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse> getGetEventsByContractKeyMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetEventsByContractKey",
      requestType = com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest.class,
      responseType = com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest,
      com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse> getGetEventsByContractKeyMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest, com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse> getGetEventsByContractKeyMethod;
    if ((getGetEventsByContractKeyMethod = EventQueryServiceGrpc.getGetEventsByContractKeyMethod) == null) {
      synchronized (EventQueryServiceGrpc.class) {
        if ((getGetEventsByContractKeyMethod = EventQueryServiceGrpc.getGetEventsByContractKeyMethod) == null) {
          EventQueryServiceGrpc.getGetEventsByContractKeyMethod = getGetEventsByContractKeyMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest, com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetEventsByContractKey"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse.getDefaultInstance()))
              .setSchemaDescriptor(new EventQueryServiceMethodDescriptorSupplier("GetEventsByContractKey"))
              .build();
        }
      }
    }
    return getGetEventsByContractKeyMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static EventQueryServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<EventQueryServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<EventQueryServiceStub>() {
        @java.lang.Override
        public EventQueryServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new EventQueryServiceStub(channel, callOptions);
        }
      };
    return EventQueryServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static EventQueryServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<EventQueryServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<EventQueryServiceBlockingStub>() {
        @java.lang.Override
        public EventQueryServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new EventQueryServiceBlockingStub(channel, callOptions);
        }
      };
    return EventQueryServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static EventQueryServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<EventQueryServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<EventQueryServiceFutureStub>() {
        @java.lang.Override
        public EventQueryServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new EventQueryServiceFutureStub(channel, callOptions);
        }
      };
    return EventQueryServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Query events by contract id or key.
   * </pre>
   */
  public static abstract class EventQueryServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Get the create and the consuming exercise event for the contract with the provided ID.
     * No events will be returned for contracts that have been pruned because they 
     * have already been archived before the latest pruning offset. 
     * </pre>
     */
    public void getEventsByContractId(com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetEventsByContractIdMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get all create and consuming exercise events for the contracts with the provided contract key.
     * Only events for unpruned contracts will be returned.
     * Matching events are delivered in reverse chronological order, i.e.,
     * the most recent events are delivered first.
     * </pre>
     */
    public void getEventsByContractKey(com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetEventsByContractKeyMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetEventsByContractIdMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest,
                com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse>(
                  this, METHODID_GET_EVENTS_BY_CONTRACT_ID)))
          .addMethod(
            getGetEventsByContractKeyMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest,
                com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse>(
                  this, METHODID_GET_EVENTS_BY_CONTRACT_KEY)))
          .build();
    }
  }

  /**
   * <pre>
   * Query events by contract id or key.
   * </pre>
   */
  public static final class EventQueryServiceStub extends io.grpc.stub.AbstractAsyncStub<EventQueryServiceStub> {
    private EventQueryServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventQueryServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new EventQueryServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Get the create and the consuming exercise event for the contract with the provided ID.
     * No events will be returned for contracts that have been pruned because they 
     * have already been archived before the latest pruning offset. 
     * </pre>
     */
    public void getEventsByContractId(com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetEventsByContractIdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get all create and consuming exercise events for the contracts with the provided contract key.
     * Only events for unpruned contracts will be returned.
     * Matching events are delivered in reverse chronological order, i.e.,
     * the most recent events are delivered first.
     * </pre>
     */
    public void getEventsByContractKey(com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetEventsByContractKeyMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Query events by contract id or key.
   * </pre>
   */
  public static final class EventQueryServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<EventQueryServiceBlockingStub> {
    private EventQueryServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventQueryServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new EventQueryServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Get the create and the consuming exercise event for the contract with the provided ID.
     * No events will be returned for contracts that have been pruned because they 
     * have already been archived before the latest pruning offset. 
     * </pre>
     */
    public com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse getEventsByContractId(com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetEventsByContractIdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get all create and consuming exercise events for the contracts with the provided contract key.
     * Only events for unpruned contracts will be returned.
     * Matching events are delivered in reverse chronological order, i.e.,
     * the most recent events are delivered first.
     * </pre>
     */
    public com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse getEventsByContractKey(com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetEventsByContractKeyMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Query events by contract id or key.
   * </pre>
   */
  public static final class EventQueryServiceFutureStub extends io.grpc.stub.AbstractFutureStub<EventQueryServiceFutureStub> {
    private EventQueryServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventQueryServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new EventQueryServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Get the create and the consuming exercise event for the contract with the provided ID.
     * No events will be returned for contracts that have been pruned because they 
     * have already been archived before the latest pruning offset. 
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse> getEventsByContractId(
        com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetEventsByContractIdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get all create and consuming exercise events for the contracts with the provided contract key.
     * Only events for unpruned contracts will be returned.
     * Matching events are delivered in reverse chronological order, i.e.,
     * the most recent events are delivered first.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse> getEventsByContractKey(
        com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetEventsByContractKeyMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_EVENTS_BY_CONTRACT_ID = 0;
  private static final int METHODID_GET_EVENTS_BY_CONTRACT_KEY = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final EventQueryServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(EventQueryServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_EVENTS_BY_CONTRACT_ID:
          serviceImpl.getEventsByContractId((com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractIdResponse>) responseObserver);
          break;
        case METHODID_GET_EVENTS_BY_CONTRACT_KEY:
          serviceImpl.getEventsByContractKey((com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.EventQueryServiceOuterClass.GetEventsByContractKeyResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class EventQueryServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    EventQueryServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.EventQueryServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("EventQueryService");
    }
  }

  private static final class EventQueryServiceFileDescriptorSupplier
      extends EventQueryServiceBaseDescriptorSupplier {
    EventQueryServiceFileDescriptorSupplier() {}
  }

  private static final class EventQueryServiceMethodDescriptorSupplier
      extends EventQueryServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    EventQueryServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (EventQueryServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new EventQueryServiceFileDescriptorSupplier())
              .addMethod(getGetEventsByContractIdMethod())
              .addMethod(getGetEventsByContractKeyMethod())
              .build();
        }
      }
    }
    return result;
  }
}
