package com.daml.ledger.api.v1.admin;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Identity Provider Config Service makes it possible for participant node administrators
 * to setup and manage additional identity providers at runtime.
 * This allows using access tokens from identity providers unknown at deployment time. When an identity
 * provider is configured, independent IDP administrators can manage their own set of parties and users.
 * Such parties and users have a matching `identity_provider_id` defined and are inaccessible to
 * administrators from other identity providers. A user will only be authenticated if the corresponding JWT
 * token is issued by the appropriate identity provider.
 * Users and parties without `identity_provider_id` defined are assumed to be using the default identity provider,
 * which is configured statically at the participant node's deployment time.
 * The Ledger API uses the "iss" claim of a JWT token to match the token to a specific IDP. If there is no match,
 * the default IDP is assumed.
 * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
 * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
 * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
 * An identity provider config resource is described by the ``IdentityProviderConfig`` message,
 * An identity provider config resource, once it has been created, can be modified.
 * In order to update the properties represented by the ``IdentityProviderConfig`` message use the ``UpdateIdentityProviderConfig`` RPC.
 * The only fields that can be modified are those marked as ``Modifiable``.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/admin/identity_provider_config_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class IdentityProviderConfigServiceGrpc {

  private IdentityProviderConfigServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.admin.IdentityProviderConfigService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest,
      com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse> getCreateIdentityProviderConfigMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateIdentityProviderConfig",
      requestType = com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest.class,
      responseType = com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest,
      com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse> getCreateIdentityProviderConfigMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest, com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse> getCreateIdentityProviderConfigMethod;
    if ((getCreateIdentityProviderConfigMethod = IdentityProviderConfigServiceGrpc.getCreateIdentityProviderConfigMethod) == null) {
      synchronized (IdentityProviderConfigServiceGrpc.class) {
        if ((getCreateIdentityProviderConfigMethod = IdentityProviderConfigServiceGrpc.getCreateIdentityProviderConfigMethod) == null) {
          IdentityProviderConfigServiceGrpc.getCreateIdentityProviderConfigMethod = getCreateIdentityProviderConfigMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest, com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateIdentityProviderConfig"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse.getDefaultInstance()))
              .setSchemaDescriptor(new IdentityProviderConfigServiceMethodDescriptorSupplier("CreateIdentityProviderConfig"))
              .build();
        }
      }
    }
    return getCreateIdentityProviderConfigMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest,
      com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse> getGetIdentityProviderConfigMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetIdentityProviderConfig",
      requestType = com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest.class,
      responseType = com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest,
      com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse> getGetIdentityProviderConfigMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest, com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse> getGetIdentityProviderConfigMethod;
    if ((getGetIdentityProviderConfigMethod = IdentityProviderConfigServiceGrpc.getGetIdentityProviderConfigMethod) == null) {
      synchronized (IdentityProviderConfigServiceGrpc.class) {
        if ((getGetIdentityProviderConfigMethod = IdentityProviderConfigServiceGrpc.getGetIdentityProviderConfigMethod) == null) {
          IdentityProviderConfigServiceGrpc.getGetIdentityProviderConfigMethod = getGetIdentityProviderConfigMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest, com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetIdentityProviderConfig"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse.getDefaultInstance()))
              .setSchemaDescriptor(new IdentityProviderConfigServiceMethodDescriptorSupplier("GetIdentityProviderConfig"))
              .build();
        }
      }
    }
    return getGetIdentityProviderConfigMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest,
      com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse> getUpdateIdentityProviderConfigMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UpdateIdentityProviderConfig",
      requestType = com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest.class,
      responseType = com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest,
      com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse> getUpdateIdentityProviderConfigMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest, com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse> getUpdateIdentityProviderConfigMethod;
    if ((getUpdateIdentityProviderConfigMethod = IdentityProviderConfigServiceGrpc.getUpdateIdentityProviderConfigMethod) == null) {
      synchronized (IdentityProviderConfigServiceGrpc.class) {
        if ((getUpdateIdentityProviderConfigMethod = IdentityProviderConfigServiceGrpc.getUpdateIdentityProviderConfigMethod) == null) {
          IdentityProviderConfigServiceGrpc.getUpdateIdentityProviderConfigMethod = getUpdateIdentityProviderConfigMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest, com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "UpdateIdentityProviderConfig"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse.getDefaultInstance()))
              .setSchemaDescriptor(new IdentityProviderConfigServiceMethodDescriptorSupplier("UpdateIdentityProviderConfig"))
              .build();
        }
      }
    }
    return getUpdateIdentityProviderConfigMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest,
      com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse> getListIdentityProviderConfigsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListIdentityProviderConfigs",
      requestType = com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest.class,
      responseType = com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest,
      com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse> getListIdentityProviderConfigsMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest, com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse> getListIdentityProviderConfigsMethod;
    if ((getListIdentityProviderConfigsMethod = IdentityProviderConfigServiceGrpc.getListIdentityProviderConfigsMethod) == null) {
      synchronized (IdentityProviderConfigServiceGrpc.class) {
        if ((getListIdentityProviderConfigsMethod = IdentityProviderConfigServiceGrpc.getListIdentityProviderConfigsMethod) == null) {
          IdentityProviderConfigServiceGrpc.getListIdentityProviderConfigsMethod = getListIdentityProviderConfigsMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest, com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListIdentityProviderConfigs"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new IdentityProviderConfigServiceMethodDescriptorSupplier("ListIdentityProviderConfigs"))
              .build();
        }
      }
    }
    return getListIdentityProviderConfigsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest,
      com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse> getDeleteIdentityProviderConfigMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteIdentityProviderConfig",
      requestType = com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest.class,
      responseType = com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest,
      com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse> getDeleteIdentityProviderConfigMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest, com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse> getDeleteIdentityProviderConfigMethod;
    if ((getDeleteIdentityProviderConfigMethod = IdentityProviderConfigServiceGrpc.getDeleteIdentityProviderConfigMethod) == null) {
      synchronized (IdentityProviderConfigServiceGrpc.class) {
        if ((getDeleteIdentityProviderConfigMethod = IdentityProviderConfigServiceGrpc.getDeleteIdentityProviderConfigMethod) == null) {
          IdentityProviderConfigServiceGrpc.getDeleteIdentityProviderConfigMethod = getDeleteIdentityProviderConfigMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest, com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteIdentityProviderConfig"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse.getDefaultInstance()))
              .setSchemaDescriptor(new IdentityProviderConfigServiceMethodDescriptorSupplier("DeleteIdentityProviderConfig"))
              .build();
        }
      }
    }
    return getDeleteIdentityProviderConfigMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static IdentityProviderConfigServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<IdentityProviderConfigServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<IdentityProviderConfigServiceStub>() {
        @java.lang.Override
        public IdentityProviderConfigServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new IdentityProviderConfigServiceStub(channel, callOptions);
        }
      };
    return IdentityProviderConfigServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static IdentityProviderConfigServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<IdentityProviderConfigServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<IdentityProviderConfigServiceBlockingStub>() {
        @java.lang.Override
        public IdentityProviderConfigServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new IdentityProviderConfigServiceBlockingStub(channel, callOptions);
        }
      };
    return IdentityProviderConfigServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static IdentityProviderConfigServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<IdentityProviderConfigServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<IdentityProviderConfigServiceFutureStub>() {
        @java.lang.Override
        public IdentityProviderConfigServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new IdentityProviderConfigServiceFutureStub(channel, callOptions);
        }
      };
    return IdentityProviderConfigServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Identity Provider Config Service makes it possible for participant node administrators
   * to setup and manage additional identity providers at runtime.
   * This allows using access tokens from identity providers unknown at deployment time. When an identity
   * provider is configured, independent IDP administrators can manage their own set of parties and users.
   * Such parties and users have a matching `identity_provider_id` defined and are inaccessible to
   * administrators from other identity providers. A user will only be authenticated if the corresponding JWT
   * token is issued by the appropriate identity provider.
   * Users and parties without `identity_provider_id` defined are assumed to be using the default identity provider,
   * which is configured statically at the participant node's deployment time.
   * The Ledger API uses the "iss" claim of a JWT token to match the token to a specific IDP. If there is no match,
   * the default IDP is assumed.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * An identity provider config resource is described by the ``IdentityProviderConfig`` message,
   * An identity provider config resource, once it has been created, can be modified.
   * In order to update the properties represented by the ``IdentityProviderConfig`` message use the ``UpdateIdentityProviderConfig`` RPC.
   * The only fields that can be modified are those marked as ``Modifiable``.
   * </pre>
   */
  public static abstract class IdentityProviderConfigServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Create a new identity provider configuration.
     * The request will fail if the maximum allowed number of separate configurations is reached.
     * </pre>
     */
    public void createIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCreateIdentityProviderConfigMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get the identity provider configuration data by id.
     * </pre>
     */
    public void getIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetIdentityProviderConfigMethod(), responseObserver);
    }

    /**
     * <pre>
     * Update selected modifiable attribute of an identity provider config resource described
     * by the ``IdentityProviderConfig`` message.
     * </pre>
     */
    public void updateIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdateIdentityProviderConfigMethod(), responseObserver);
    }

    /**
     * <pre>
     * List all existing identity provider configurations.
     * </pre>
     */
    public void listIdentityProviderConfigs(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListIdentityProviderConfigsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Delete an existing identity provider configuration.
     * </pre>
     */
    public void deleteIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getDeleteIdentityProviderConfigMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getCreateIdentityProviderConfigMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest,
                com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse>(
                  this, METHODID_CREATE_IDENTITY_PROVIDER_CONFIG)))
          .addMethod(
            getGetIdentityProviderConfigMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest,
                com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse>(
                  this, METHODID_GET_IDENTITY_PROVIDER_CONFIG)))
          .addMethod(
            getUpdateIdentityProviderConfigMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest,
                com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse>(
                  this, METHODID_UPDATE_IDENTITY_PROVIDER_CONFIG)))
          .addMethod(
            getListIdentityProviderConfigsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest,
                com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse>(
                  this, METHODID_LIST_IDENTITY_PROVIDER_CONFIGS)))
          .addMethod(
            getDeleteIdentityProviderConfigMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest,
                com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse>(
                  this, METHODID_DELETE_IDENTITY_PROVIDER_CONFIG)))
          .build();
    }
  }

  /**
   * <pre>
   * Identity Provider Config Service makes it possible for participant node administrators
   * to setup and manage additional identity providers at runtime.
   * This allows using access tokens from identity providers unknown at deployment time. When an identity
   * provider is configured, independent IDP administrators can manage their own set of parties and users.
   * Such parties and users have a matching `identity_provider_id` defined and are inaccessible to
   * administrators from other identity providers. A user will only be authenticated if the corresponding JWT
   * token is issued by the appropriate identity provider.
   * Users and parties without `identity_provider_id` defined are assumed to be using the default identity provider,
   * which is configured statically at the participant node's deployment time.
   * The Ledger API uses the "iss" claim of a JWT token to match the token to a specific IDP. If there is no match,
   * the default IDP is assumed.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * An identity provider config resource is described by the ``IdentityProviderConfig`` message,
   * An identity provider config resource, once it has been created, can be modified.
   * In order to update the properties represented by the ``IdentityProviderConfig`` message use the ``UpdateIdentityProviderConfig`` RPC.
   * The only fields that can be modified are those marked as ``Modifiable``.
   * </pre>
   */
  public static final class IdentityProviderConfigServiceStub extends io.grpc.stub.AbstractAsyncStub<IdentityProviderConfigServiceStub> {
    private IdentityProviderConfigServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected IdentityProviderConfigServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new IdentityProviderConfigServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Create a new identity provider configuration.
     * The request will fail if the maximum allowed number of separate configurations is reached.
     * </pre>
     */
    public void createIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCreateIdentityProviderConfigMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get the identity provider configuration data by id.
     * </pre>
     */
    public void getIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetIdentityProviderConfigMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Update selected modifiable attribute of an identity provider config resource described
     * by the ``IdentityProviderConfig`` message.
     * </pre>
     */
    public void updateIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdateIdentityProviderConfigMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * List all existing identity provider configurations.
     * </pre>
     */
    public void listIdentityProviderConfigs(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListIdentityProviderConfigsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Delete an existing identity provider configuration.
     * </pre>
     */
    public void deleteIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getDeleteIdentityProviderConfigMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Identity Provider Config Service makes it possible for participant node administrators
   * to setup and manage additional identity providers at runtime.
   * This allows using access tokens from identity providers unknown at deployment time. When an identity
   * provider is configured, independent IDP administrators can manage their own set of parties and users.
   * Such parties and users have a matching `identity_provider_id` defined and are inaccessible to
   * administrators from other identity providers. A user will only be authenticated if the corresponding JWT
   * token is issued by the appropriate identity provider.
   * Users and parties without `identity_provider_id` defined are assumed to be using the default identity provider,
   * which is configured statically at the participant node's deployment time.
   * The Ledger API uses the "iss" claim of a JWT token to match the token to a specific IDP. If there is no match,
   * the default IDP is assumed.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * An identity provider config resource is described by the ``IdentityProviderConfig`` message,
   * An identity provider config resource, once it has been created, can be modified.
   * In order to update the properties represented by the ``IdentityProviderConfig`` message use the ``UpdateIdentityProviderConfig`` RPC.
   * The only fields that can be modified are those marked as ``Modifiable``.
   * </pre>
   */
  public static final class IdentityProviderConfigServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<IdentityProviderConfigServiceBlockingStub> {
    private IdentityProviderConfigServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected IdentityProviderConfigServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new IdentityProviderConfigServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Create a new identity provider configuration.
     * The request will fail if the maximum allowed number of separate configurations is reached.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse createIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCreateIdentityProviderConfigMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get the identity provider configuration data by id.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse getIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetIdentityProviderConfigMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Update selected modifiable attribute of an identity provider config resource described
     * by the ``IdentityProviderConfig`` message.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse updateIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdateIdentityProviderConfigMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * List all existing identity provider configurations.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse listIdentityProviderConfigs(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListIdentityProviderConfigsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Delete an existing identity provider configuration.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse deleteIdentityProviderConfig(com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getDeleteIdentityProviderConfigMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Identity Provider Config Service makes it possible for participant node administrators
   * to setup and manage additional identity providers at runtime.
   * This allows using access tokens from identity providers unknown at deployment time. When an identity
   * provider is configured, independent IDP administrators can manage their own set of parties and users.
   * Such parties and users have a matching `identity_provider_id` defined and are inaccessible to
   * administrators from other identity providers. A user will only be authenticated if the corresponding JWT
   * token is issued by the appropriate identity provider.
   * Users and parties without `identity_provider_id` defined are assumed to be using the default identity provider,
   * which is configured statically at the participant node's deployment time.
   * The Ledger API uses the "iss" claim of a JWT token to match the token to a specific IDP. If there is no match,
   * the default IDP is assumed.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * An identity provider config resource is described by the ``IdentityProviderConfig`` message,
   * An identity provider config resource, once it has been created, can be modified.
   * In order to update the properties represented by the ``IdentityProviderConfig`` message use the ``UpdateIdentityProviderConfig`` RPC.
   * The only fields that can be modified are those marked as ``Modifiable``.
   * </pre>
   */
  public static final class IdentityProviderConfigServiceFutureStub extends io.grpc.stub.AbstractFutureStub<IdentityProviderConfigServiceFutureStub> {
    private IdentityProviderConfigServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected IdentityProviderConfigServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new IdentityProviderConfigServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Create a new identity provider configuration.
     * The request will fail if the maximum allowed number of separate configurations is reached.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse> createIdentityProviderConfig(
        com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCreateIdentityProviderConfigMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get the identity provider configuration data by id.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse> getIdentityProviderConfig(
        com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetIdentityProviderConfigMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Update selected modifiable attribute of an identity provider config resource described
     * by the ``IdentityProviderConfig`` message.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse> updateIdentityProviderConfig(
        com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdateIdentityProviderConfigMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * List all existing identity provider configurations.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse> listIdentityProviderConfigs(
        com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListIdentityProviderConfigsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Delete an existing identity provider configuration.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse> deleteIdentityProviderConfig(
        com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getDeleteIdentityProviderConfigMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_CREATE_IDENTITY_PROVIDER_CONFIG = 0;
  private static final int METHODID_GET_IDENTITY_PROVIDER_CONFIG = 1;
  private static final int METHODID_UPDATE_IDENTITY_PROVIDER_CONFIG = 2;
  private static final int METHODID_LIST_IDENTITY_PROVIDER_CONFIGS = 3;
  private static final int METHODID_DELETE_IDENTITY_PROVIDER_CONFIG = 4;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final IdentityProviderConfigServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(IdentityProviderConfigServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_CREATE_IDENTITY_PROVIDER_CONFIG:
          serviceImpl.createIdentityProviderConfig((com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.CreateIdentityProviderConfigResponse>) responseObserver);
          break;
        case METHODID_GET_IDENTITY_PROVIDER_CONFIG:
          serviceImpl.getIdentityProviderConfig((com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.GetIdentityProviderConfigResponse>) responseObserver);
          break;
        case METHODID_UPDATE_IDENTITY_PROVIDER_CONFIG:
          serviceImpl.updateIdentityProviderConfig((com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.UpdateIdentityProviderConfigResponse>) responseObserver);
          break;
        case METHODID_LIST_IDENTITY_PROVIDER_CONFIGS:
          serviceImpl.listIdentityProviderConfigs((com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.ListIdentityProviderConfigsResponse>) responseObserver);
          break;
        case METHODID_DELETE_IDENTITY_PROVIDER_CONFIG:
          serviceImpl.deleteIdentityProviderConfig((com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.DeleteIdentityProviderConfigResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class IdentityProviderConfigServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    IdentityProviderConfigServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.admin.IdentityProviderConfigServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("IdentityProviderConfigService");
    }
  }

  private static final class IdentityProviderConfigServiceFileDescriptorSupplier
      extends IdentityProviderConfigServiceBaseDescriptorSupplier {
    IdentityProviderConfigServiceFileDescriptorSupplier() {}
  }

  private static final class IdentityProviderConfigServiceMethodDescriptorSupplier
      extends IdentityProviderConfigServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    IdentityProviderConfigServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (IdentityProviderConfigServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new IdentityProviderConfigServiceFileDescriptorSupplier())
              .addMethod(getCreateIdentityProviderConfigMethod())
              .addMethod(getGetIdentityProviderConfigMethod())
              .addMethod(getUpdateIdentityProviderConfigMethod())
              .addMethod(getListIdentityProviderConfigsMethod())
              .addMethod(getDeleteIdentityProviderConfigMethod())
              .build();
        }
      }
    }
    return result;
  }
}
