package com.daml.ledger.api.v1.admin;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * This service allows inspecting the party management state of the ledger known to the participant
 * and managing the participant-local party metadata.
 * The authorization rules for its RPCs are specified on the ``&lt;RpcName&gt;Request``
 * messages as boolean expressions over these facts:
 * (1) ``HasRight(r)`` denoting whether the authenticated user has right ``r`` and
 * (2) ``IsAuthenticatedIdentityProviderAdmin(idp)`` denoting whether ``idp`` is equal to the ``identity_provider_id``
 * of the authenticated user and the user has an IdentityProviderAdmin right.
 * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
 * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
 * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
 * A party details resource is described by the ``PartyDetails`` message,
 * A party details resource, once it has been created, can be modified using the ``UpdatePartyDetails`` RPC.
 * The only fields that can be modified are those marked as ``Modifiable``.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/admin/party_management_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class PartyManagementServiceGrpc {

  private PartyManagementServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.admin.PartyManagementService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> getGetParticipantIdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetParticipantId",
      requestType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest.class,
      responseType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> getGetParticipantIdMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> getGetParticipantIdMethod;
    if ((getGetParticipantIdMethod = PartyManagementServiceGrpc.getGetParticipantIdMethod) == null) {
      synchronized (PartyManagementServiceGrpc.class) {
        if ((getGetParticipantIdMethod = PartyManagementServiceGrpc.getGetParticipantIdMethod) == null) {
          PartyManagementServiceGrpc.getGetParticipantIdMethod = getGetParticipantIdMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetParticipantId"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PartyManagementServiceMethodDescriptorSupplier("GetParticipantId"))
              .build();
        }
      }
    }
    return getGetParticipantIdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> getGetPartiesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetParties",
      requestType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest.class,
      responseType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> getGetPartiesMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> getGetPartiesMethod;
    if ((getGetPartiesMethod = PartyManagementServiceGrpc.getGetPartiesMethod) == null) {
      synchronized (PartyManagementServiceGrpc.class) {
        if ((getGetPartiesMethod = PartyManagementServiceGrpc.getGetPartiesMethod) == null) {
          PartyManagementServiceGrpc.getGetPartiesMethod = getGetPartiesMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetParties"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PartyManagementServiceMethodDescriptorSupplier("GetParties"))
              .build();
        }
      }
    }
    return getGetPartiesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> getListKnownPartiesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListKnownParties",
      requestType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest.class,
      responseType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> getListKnownPartiesMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> getListKnownPartiesMethod;
    if ((getListKnownPartiesMethod = PartyManagementServiceGrpc.getListKnownPartiesMethod) == null) {
      synchronized (PartyManagementServiceGrpc.class) {
        if ((getListKnownPartiesMethod = PartyManagementServiceGrpc.getListKnownPartiesMethod) == null) {
          PartyManagementServiceGrpc.getListKnownPartiesMethod = getListKnownPartiesMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListKnownParties"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PartyManagementServiceMethodDescriptorSupplier("ListKnownParties"))
              .build();
        }
      }
    }
    return getListKnownPartiesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> getAllocatePartyMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AllocateParty",
      requestType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest.class,
      responseType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> getAllocatePartyMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> getAllocatePartyMethod;
    if ((getAllocatePartyMethod = PartyManagementServiceGrpc.getAllocatePartyMethod) == null) {
      synchronized (PartyManagementServiceGrpc.class) {
        if ((getAllocatePartyMethod = PartyManagementServiceGrpc.getAllocatePartyMethod) == null) {
          PartyManagementServiceGrpc.getAllocatePartyMethod = getAllocatePartyMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "AllocateParty"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PartyManagementServiceMethodDescriptorSupplier("AllocateParty"))
              .build();
        }
      }
    }
    return getAllocatePartyMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse> getUpdatePartyDetailsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UpdatePartyDetails",
      requestType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest.class,
      responseType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse> getUpdatePartyDetailsMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse> getUpdatePartyDetailsMethod;
    if ((getUpdatePartyDetailsMethod = PartyManagementServiceGrpc.getUpdatePartyDetailsMethod) == null) {
      synchronized (PartyManagementServiceGrpc.class) {
        if ((getUpdatePartyDetailsMethod = PartyManagementServiceGrpc.getUpdatePartyDetailsMethod) == null) {
          PartyManagementServiceGrpc.getUpdatePartyDetailsMethod = getUpdatePartyDetailsMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "UpdatePartyDetails"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PartyManagementServiceMethodDescriptorSupplier("UpdatePartyDetails"))
              .build();
        }
      }
    }
    return getUpdatePartyDetailsMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static PartyManagementServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PartyManagementServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PartyManagementServiceStub>() {
        @java.lang.Override
        public PartyManagementServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PartyManagementServiceStub(channel, callOptions);
        }
      };
    return PartyManagementServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static PartyManagementServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PartyManagementServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PartyManagementServiceBlockingStub>() {
        @java.lang.Override
        public PartyManagementServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PartyManagementServiceBlockingStub(channel, callOptions);
        }
      };
    return PartyManagementServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static PartyManagementServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PartyManagementServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PartyManagementServiceFutureStub>() {
        @java.lang.Override
        public PartyManagementServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PartyManagementServiceFutureStub(channel, callOptions);
        }
      };
    return PartyManagementServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * This service allows inspecting the party management state of the ledger known to the participant
   * and managing the participant-local party metadata.
   * The authorization rules for its RPCs are specified on the ``&lt;RpcName&gt;Request``
   * messages as boolean expressions over these facts:
   * (1) ``HasRight(r)`` denoting whether the authenticated user has right ``r`` and
   * (2) ``IsAuthenticatedIdentityProviderAdmin(idp)`` denoting whether ``idp`` is equal to the ``identity_provider_id``
   * of the authenticated user and the user has an IdentityProviderAdmin right.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * A party details resource is described by the ``PartyDetails`` message,
   * A party details resource, once it has been created, can be modified using the ``UpdatePartyDetails`` RPC.
   * The only fields that can be modified are those marked as ``Modifiable``.
   * </pre>
   */
  public static abstract class PartyManagementServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Return the identifier of the participant.
     * All horizontally scaled replicas should return the same id.
     * daml-on-kv-ledger: returns an identifier supplied on command line at launch time
     * canton: returns globally unique identifier of the participant
     * </pre>
     */
    public void getParticipantId(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetParticipantIdMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get the party details of the given parties. Only known parties will be
     * returned in the list.
     * </pre>
     */
    public void getParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetPartiesMethod(), responseObserver);
    }

    /**
     * <pre>
     * List the parties known by the participant.
     * The list returned contains parties whose ledger access is facilitated by
     * the participant and the ones maintained elsewhere.
     * </pre>
     */
    public void listKnownParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListKnownPartiesMethod(), responseObserver);
    }

    /**
     * <pre>
     * Allocates a new party on a ledger and adds it to the set managed by the participant.
     * Caller specifies a party identifier suggestion, the actual identifier
     * allocated might be different and is implementation specific.
     * Caller can specify party metadata that is stored locally on the participant.
     * This call may:
     * - Succeed, in which case the actual allocated identifier is visible in
     *   the response.
     * - Respond with a gRPC error
     * daml-on-kv-ledger: suggestion's uniqueness is checked by the validators in
     * the consensus layer and call rejected if the identifier is already present.
     * canton: completely different globally unique identifier is allocated.
     * Behind the scenes calls to an internal protocol are made. As that protocol
     * is richer than the surface protocol, the arguments take implicit values
     * The party identifier suggestion must be a valid party name. Party names are required to be non-empty US-ASCII strings built from letters, digits, space,
     * colon, minus and underscore limited to 255 chars
     * </pre>
     */
    public void allocateParty(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getAllocatePartyMethod(), responseObserver);
    }

    /**
     * <pre>
     * Update selected modifiable participant-local attributes of a party details resource.
     * Can update the participant's local information for local parties.
     * </pre>
     */
    public void updatePartyDetails(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdatePartyDetailsMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetParticipantIdMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest,
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse>(
                  this, METHODID_GET_PARTICIPANT_ID)))
          .addMethod(
            getGetPartiesMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest,
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse>(
                  this, METHODID_GET_PARTIES)))
          .addMethod(
            getListKnownPartiesMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest,
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse>(
                  this, METHODID_LIST_KNOWN_PARTIES)))
          .addMethod(
            getAllocatePartyMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest,
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse>(
                  this, METHODID_ALLOCATE_PARTY)))
          .addMethod(
            getUpdatePartyDetailsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest,
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse>(
                  this, METHODID_UPDATE_PARTY_DETAILS)))
          .build();
    }
  }

  /**
   * <pre>
   * This service allows inspecting the party management state of the ledger known to the participant
   * and managing the participant-local party metadata.
   * The authorization rules for its RPCs are specified on the ``&lt;RpcName&gt;Request``
   * messages as boolean expressions over these facts:
   * (1) ``HasRight(r)`` denoting whether the authenticated user has right ``r`` and
   * (2) ``IsAuthenticatedIdentityProviderAdmin(idp)`` denoting whether ``idp`` is equal to the ``identity_provider_id``
   * of the authenticated user and the user has an IdentityProviderAdmin right.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * A party details resource is described by the ``PartyDetails`` message,
   * A party details resource, once it has been created, can be modified using the ``UpdatePartyDetails`` RPC.
   * The only fields that can be modified are those marked as ``Modifiable``.
   * </pre>
   */
  public static final class PartyManagementServiceStub extends io.grpc.stub.AbstractAsyncStub<PartyManagementServiceStub> {
    private PartyManagementServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PartyManagementServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PartyManagementServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Return the identifier of the participant.
     * All horizontally scaled replicas should return the same id.
     * daml-on-kv-ledger: returns an identifier supplied on command line at launch time
     * canton: returns globally unique identifier of the participant
     * </pre>
     */
    public void getParticipantId(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetParticipantIdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get the party details of the given parties. Only known parties will be
     * returned in the list.
     * </pre>
     */
    public void getParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetPartiesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * List the parties known by the participant.
     * The list returned contains parties whose ledger access is facilitated by
     * the participant and the ones maintained elsewhere.
     * </pre>
     */
    public void listKnownParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListKnownPartiesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Allocates a new party on a ledger and adds it to the set managed by the participant.
     * Caller specifies a party identifier suggestion, the actual identifier
     * allocated might be different and is implementation specific.
     * Caller can specify party metadata that is stored locally on the participant.
     * This call may:
     * - Succeed, in which case the actual allocated identifier is visible in
     *   the response.
     * - Respond with a gRPC error
     * daml-on-kv-ledger: suggestion's uniqueness is checked by the validators in
     * the consensus layer and call rejected if the identifier is already present.
     * canton: completely different globally unique identifier is allocated.
     * Behind the scenes calls to an internal protocol are made. As that protocol
     * is richer than the surface protocol, the arguments take implicit values
     * The party identifier suggestion must be a valid party name. Party names are required to be non-empty US-ASCII strings built from letters, digits, space,
     * colon, minus and underscore limited to 255 chars
     * </pre>
     */
    public void allocateParty(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getAllocatePartyMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Update selected modifiable participant-local attributes of a party details resource.
     * Can update the participant's local information for local parties.
     * </pre>
     */
    public void updatePartyDetails(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdatePartyDetailsMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * This service allows inspecting the party management state of the ledger known to the participant
   * and managing the participant-local party metadata.
   * The authorization rules for its RPCs are specified on the ``&lt;RpcName&gt;Request``
   * messages as boolean expressions over these facts:
   * (1) ``HasRight(r)`` denoting whether the authenticated user has right ``r`` and
   * (2) ``IsAuthenticatedIdentityProviderAdmin(idp)`` denoting whether ``idp`` is equal to the ``identity_provider_id``
   * of the authenticated user and the user has an IdentityProviderAdmin right.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * A party details resource is described by the ``PartyDetails`` message,
   * A party details resource, once it has been created, can be modified using the ``UpdatePartyDetails`` RPC.
   * The only fields that can be modified are those marked as ``Modifiable``.
   * </pre>
   */
  public static final class PartyManagementServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<PartyManagementServiceBlockingStub> {
    private PartyManagementServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PartyManagementServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PartyManagementServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Return the identifier of the participant.
     * All horizontally scaled replicas should return the same id.
     * daml-on-kv-ledger: returns an identifier supplied on command line at launch time
     * canton: returns globally unique identifier of the participant
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse getParticipantId(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetParticipantIdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get the party details of the given parties. Only known parties will be
     * returned in the list.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse getParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetPartiesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * List the parties known by the participant.
     * The list returned contains parties whose ledger access is facilitated by
     * the participant and the ones maintained elsewhere.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse listKnownParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListKnownPartiesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Allocates a new party on a ledger and adds it to the set managed by the participant.
     * Caller specifies a party identifier suggestion, the actual identifier
     * allocated might be different and is implementation specific.
     * Caller can specify party metadata that is stored locally on the participant.
     * This call may:
     * - Succeed, in which case the actual allocated identifier is visible in
     *   the response.
     * - Respond with a gRPC error
     * daml-on-kv-ledger: suggestion's uniqueness is checked by the validators in
     * the consensus layer and call rejected if the identifier is already present.
     * canton: completely different globally unique identifier is allocated.
     * Behind the scenes calls to an internal protocol are made. As that protocol
     * is richer than the surface protocol, the arguments take implicit values
     * The party identifier suggestion must be a valid party name. Party names are required to be non-empty US-ASCII strings built from letters, digits, space,
     * colon, minus and underscore limited to 255 chars
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse allocateParty(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getAllocatePartyMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Update selected modifiable participant-local attributes of a party details resource.
     * Can update the participant's local information for local parties.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse updatePartyDetails(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdatePartyDetailsMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * This service allows inspecting the party management state of the ledger known to the participant
   * and managing the participant-local party metadata.
   * The authorization rules for its RPCs are specified on the ``&lt;RpcName&gt;Request``
   * messages as boolean expressions over these facts:
   * (1) ``HasRight(r)`` denoting whether the authenticated user has right ``r`` and
   * (2) ``IsAuthenticatedIdentityProviderAdmin(idp)`` denoting whether ``idp`` is equal to the ``identity_provider_id``
   * of the authenticated user and the user has an IdentityProviderAdmin right.
   * The fields of request messages (and sub-messages) are marked either as ``Optional`` or ``Required``:
   * (1) ``Optional`` denoting the client may leave the field unset when sending a request.
   * (2) ``Required`` denoting the client must set the field to a non-default value when sending a request.
   * A party details resource is described by the ``PartyDetails`` message,
   * A party details resource, once it has been created, can be modified using the ``UpdatePartyDetails`` RPC.
   * The only fields that can be modified are those marked as ``Modifiable``.
   * </pre>
   */
  public static final class PartyManagementServiceFutureStub extends io.grpc.stub.AbstractFutureStub<PartyManagementServiceFutureStub> {
    private PartyManagementServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PartyManagementServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PartyManagementServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Return the identifier of the participant.
     * All horizontally scaled replicas should return the same id.
     * daml-on-kv-ledger: returns an identifier supplied on command line at launch time
     * canton: returns globally unique identifier of the participant
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> getParticipantId(
        com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetParticipantIdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get the party details of the given parties. Only known parties will be
     * returned in the list.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> getParties(
        com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetPartiesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * List the parties known by the participant.
     * The list returned contains parties whose ledger access is facilitated by
     * the participant and the ones maintained elsewhere.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> listKnownParties(
        com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListKnownPartiesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Allocates a new party on a ledger and adds it to the set managed by the participant.
     * Caller specifies a party identifier suggestion, the actual identifier
     * allocated might be different and is implementation specific.
     * Caller can specify party metadata that is stored locally on the participant.
     * This call may:
     * - Succeed, in which case the actual allocated identifier is visible in
     *   the response.
     * - Respond with a gRPC error
     * daml-on-kv-ledger: suggestion's uniqueness is checked by the validators in
     * the consensus layer and call rejected if the identifier is already present.
     * canton: completely different globally unique identifier is allocated.
     * Behind the scenes calls to an internal protocol are made. As that protocol
     * is richer than the surface protocol, the arguments take implicit values
     * The party identifier suggestion must be a valid party name. Party names are required to be non-empty US-ASCII strings built from letters, digits, space,
     * colon, minus and underscore limited to 255 chars
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> allocateParty(
        com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getAllocatePartyMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Update selected modifiable participant-local attributes of a party details resource.
     * Can update the participant's local information for local parties.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse> updatePartyDetails(
        com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdatePartyDetailsMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_PARTICIPANT_ID = 0;
  private static final int METHODID_GET_PARTIES = 1;
  private static final int METHODID_LIST_KNOWN_PARTIES = 2;
  private static final int METHODID_ALLOCATE_PARTY = 3;
  private static final int METHODID_UPDATE_PARTY_DETAILS = 4;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final PartyManagementServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(PartyManagementServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_PARTICIPANT_ID:
          serviceImpl.getParticipantId((com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse>) responseObserver);
          break;
        case METHODID_GET_PARTIES:
          serviceImpl.getParties((com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse>) responseObserver);
          break;
        case METHODID_LIST_KNOWN_PARTIES:
          serviceImpl.listKnownParties((com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse>) responseObserver);
          break;
        case METHODID_ALLOCATE_PARTY:
          serviceImpl.allocateParty((com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse>) responseObserver);
          break;
        case METHODID_UPDATE_PARTY_DETAILS:
          serviceImpl.updatePartyDetails((com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.UpdatePartyDetailsResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class PartyManagementServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    PartyManagementServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("PartyManagementService");
    }
  }

  private static final class PartyManagementServiceFileDescriptorSupplier
      extends PartyManagementServiceBaseDescriptorSupplier {
    PartyManagementServiceFileDescriptorSupplier() {}
  }

  private static final class PartyManagementServiceMethodDescriptorSupplier
      extends PartyManagementServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    PartyManagementServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (PartyManagementServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new PartyManagementServiceFileDescriptorSupplier())
              .addMethod(getGetParticipantIdMethod())
              .addMethod(getGetPartiesMethod())
              .addMethod(getListKnownPartiesMethod())
              .addMethod(getAllocatePartyMethod())
              .addMethod(getUpdatePartyDetailsMethod())
              .build();
        }
      }
    }
    return result;
  }
}
