/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.Filter;
import com.daml.ledger.javaapi.data.FiltersByParty;
import com.daml.ledger.javaapi.data.InclusiveFilter;
import com.daml.ledger.javaapi.data.TransactionFilter;
import com.daml.ledger.javaapi.data.codegen.Contract;
import com.daml.ledger.javaapi.data.codegen.ContractCompanion;
import com.daml.ledger.javaapi.data.codegen.ContractTypeCompanion;
import com.daml.ledger.javaapi.data.codegen.InterfaceCompanion;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ContractFilter<Ct> {
    private final ContractTypeCompanion<Ct, ?, ?, ?> companion;
    private final Filter filter;

    private ContractFilter(ContractTypeCompanion<Ct, ?, ?, ?> companion, Filter filter) {
        this.companion = companion;
        this.filter = filter;
    }

    public static <Ct> ContractFilter<Ct> of(ContractCompanion<Ct, ?, ?> companion) {
        InclusiveFilter filter = new InclusiveFilter(Collections.singleton(companion.TEMPLATE_ID), Collections.emptyMap());
        return new ContractFilter<Ct>(companion, filter);
    }

    public static <Cid, View> ContractFilter<Contract<Cid, View>> of(InterfaceCompanion<?, Cid, View> companion) {
        InclusiveFilter filter = new InclusiveFilter(Collections.emptySet(), Collections.singletonMap(companion.TEMPLATE_ID, Filter.Interface.INCLUDE_VIEW));
        return new ContractFilter<Contract<Cid, View>>(companion, filter);
    }

    public Ct toContract(CreatedEvent createdEvent) throws IllegalArgumentException {
        return this.companion.fromCreatedEvent(createdEvent);
    }

    public TransactionFilter transactionFilter(Set<String> parties) {
        return ContractFilter.transactionFilter(this.filter, parties);
    }

    private static TransactionFilter transactionFilter(Filter filter, Set<String> parties) {
        Map<String, Filter> partyToFilters = parties.stream().collect(Collectors.toMap(Function.identity(), x -> filter));
        return new FiltersByParty(partyToFilters);
    }
}

