/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.PackageServiceOuterClass;
import com.google.protobuf.ByteString;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GetPackageResponse {
    private final HashFunction hashFunction;
    private final String hash;
    private final ByteString archivePayload;

    public GetPackageResponse(HashFunction hashFunction, @NonNull String hash, @NonNull ByteString archivePayload) {
        this.hashFunction = hashFunction;
        this.hash = hash;
        this.archivePayload = archivePayload;
    }

    public HashFunction getHashFunction() {
        return this.hashFunction;
    }

    public String getHash() {
        return this.hash;
    }

    public byte[] getArchivePayload() {
        return this.archivePayload.toByteArray();
    }

    public static GetPackageResponse fromProto(PackageServiceOuterClass.GetPackageResponse p) {
        return new GetPackageResponse(HashFunction.valueOf(p.getHashFunctionValue()), p.getHash(), p.getArchivePayload());
    }

    public static enum HashFunction {
        SHA256(0),
        UNRECOGNIZED(-1);

        private final int value;
        private static Map<Integer, HashFunction> valueToEnumMap;

        private HashFunction(int value) {
            this.value = value;
        }

        public static HashFunction valueOf(int value) {
            return valueToEnumMap.getOrDefault(value, UNRECOGNIZED);
        }

        static {
            valueToEnumMap = EnumSet.allOf(HashFunction.class).stream().collect(Collectors.toMap(e -> e.value, Function.identity()));
        }
    }
}

