/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.ContractMetadataOuterClass;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ContractMetadata {
    public final Instant createdAt;
    public final ByteString driverMetadata;
    public final ByteString contractKeyHash;

    public static ContractMetadata Empty() {
        return new ContractMetadata(Instant.EPOCH, ByteString.EMPTY, ByteString.EMPTY);
    }

    public ContractMetadata(@NonNull Instant createdAt, @NonNull ByteString contractKeyHash, @NonNull ByteString driverMetadata) {
        this.createdAt = createdAt;
        this.contractKeyHash = contractKeyHash;
        this.driverMetadata = driverMetadata;
    }

    public static @NonNull ContractMetadata fromProto(ContractMetadataOuterClass.ContractMetadata metadata) {
        return new ContractMetadata(Instant.ofEpochSecond(metadata.getCreatedAt().getSeconds(), metadata.getCreatedAt().getNanos()), metadata.getContractKeyHash(), metadata.getDriverMetadata());
    }

    public ContractMetadataOuterClass.ContractMetadata toProto() {
        return ContractMetadataOuterClass.ContractMetadata.newBuilder().setCreatedAt(Timestamp.newBuilder().setSeconds(this.createdAt.getEpochSecond()).setNanos(this.createdAt.getNano()).build()).setContractKeyHash(this.contractKeyHash).setDriverMetadata(this.driverMetadata).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractMetadata that = (ContractMetadata)o;
        return Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.contractKeyHash, that.contractKeyHash) && Objects.equals(this.driverMetadata, that.driverMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.contractKeyHash, this.driverMetadata);
    }

    public String toString() {
        return "ContractMetadata{createdAt='" + this.createdAt + "', contractKeyHash='" + this.contractKeyHash + "', driverMetadata='" + this.driverMetadata + "'}";
    }
}

