/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen;

import com.daml.ledger.javaapi.data.Bool;
import com.daml.ledger.javaapi.data.DamlOptional;
import com.daml.ledger.javaapi.data.DamlRecord;
import com.daml.ledger.javaapi.data.Date;
import com.daml.ledger.javaapi.data.Int64;
import com.daml.ledger.javaapi.data.Party;
import com.daml.ledger.javaapi.data.Text;
import com.daml.ledger.javaapi.data.Timestamp;
import com.daml.ledger.javaapi.data.Unit;
import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.javaapi.data.Variant;
import com.daml.ledger.javaapi.data.codegen.ContractId;
import com.daml.ledger.javaapi.data.codegen.ValueDecoder;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrimitiveValueDecoders {
    private static final Logger logger = LoggerFactory.getLogger(PrimitiveValueDecoders.class);
    public static final ValueDecoder<Boolean> fromBool = value -> value.asBool().orElseThrow(() -> PrimitiveValueDecoders.mismatched(Bool.class)).getValue();
    public static final ValueDecoder<Long> fromInt64 = value -> value.asInt64().orElseThrow(() -> PrimitiveValueDecoders.mismatched(Int64.class)).getValue();
    public static final ValueDecoder<String> fromText = value -> value.asText().orElseThrow(() -> PrimitiveValueDecoders.mismatched(Text.class)).getValue();
    public static final ValueDecoder<Instant> fromTimestamp = value -> value.asTimestamp().orElseThrow(() -> PrimitiveValueDecoders.mismatched(Timestamp.class)).getValue();
    public static final ValueDecoder<String> fromParty = value -> value.asParty().orElseThrow(() -> PrimitiveValueDecoders.mismatched(Party.class)).getValue();
    public static final ValueDecoder<Unit> fromUnit = value -> value.asUnit().orElseThrow(() -> PrimitiveValueDecoders.mismatched(Unit.class));
    public static final ValueDecoder<LocalDate> fromDate = value -> value.asDate().orElseThrow(() -> PrimitiveValueDecoders.mismatched(Date.class)).getValue();
    public static final ValueDecoder<BigDecimal> fromNumeric = value -> value.asNumeric().orElseThrow().getValue();

    private PrimitiveValueDecoders() {
    }

    public static <T> ValueDecoder<List<T>> fromList(ValueDecoder<T> element) {
        return value -> value.asList().orElseThrow(() -> PrimitiveValueDecoders.mismatched(List.class)).toList(element::decode);
    }

    public static <T> ValueDecoder<Optional<T>> fromOptional(ValueDecoder<T> element) {
        return value -> value.asOptional().orElseThrow(() -> PrimitiveValueDecoders.mismatched(Optional.class)).toOptional(element::decode);
    }

    public static <T> ValueDecoder<ContractId<T>> fromContractId(ValueDecoder<T> contractType) {
        return value -> contractType.fromContractId(value.asContractId().orElseThrow(() -> PrimitiveValueDecoders.mismatched(ContractId.class)).getValue());
    }

    public static <T> ValueDecoder<Map<String, T>> fromTextMap(ValueDecoder<T> valueType) {
        return value -> value.asTextMap().orElseThrow(() -> PrimitiveValueDecoders.mismatched(Map.class)).toMap(valueType::decode);
    }

    public static <K, V> ValueDecoder<Map<K, V>> fromGenMap(ValueDecoder<K> keyType, ValueDecoder<V> valueType) {
        return value -> value.asGenMap().orElseThrow(() -> PrimitiveValueDecoders.mismatched(Map.class)).toMap(keyType::decode, valueType::decode);
    }

    public static <T> ValueDecoder<T> impossible() {
        return x -> {
            throw new IllegalArgumentException("Expected type to be unused, but was used for " + x);
        };
    }

    private static IllegalArgumentException mismatched(Class<?> clazz) {
        String typeName = clazz.getName();
        return new IllegalArgumentException(String.format("Expected field to be of type %s", typeName));
    }

    public static List<DamlRecord.Field> recordCheck(int expectedFields, int trailingOptionalFields, Value maybeRecord) {
        DamlRecord record = maybeRecord.asRecord().orElseThrow(() -> new IllegalArgumentException("Contracts must be constructed from Records"));
        List<DamlRecord.Field> fields = record.getFields();
        int numberOfFields = fields.size();
        if (numberOfFields == expectedFields) {
            return fields;
        }
        if (numberOfFields > expectedFields) {
            for (int i = expectedFields; i < numberOfFields; ++i) {
                DamlRecord.Field field = fields.get(i);
                Optional<DamlOptional> optValue = field.getValue().asOptional();
                if (optValue.isEmpty()) {
                    throw new IllegalArgumentException("Expected " + expectedFields + " arguments, got " + numberOfFields + " and field " + i + " is not optional: " + field);
                }
                DamlOptional value = optValue.get();
                if (value.isEmpty()) continue;
                throw new IllegalArgumentException("Expected " + expectedFields + " arguments, got " + numberOfFields + " and field " + i + " is Optional but not empty: " + field);
            }
            logger.trace("Downgrading record, dropping {} trailing optional fields", (Object)(numberOfFields - expectedFields));
            return fields.subList(0, expectedFields);
        }
        if (numberOfFields < expectedFields) {
            if (expectedFields - numberOfFields <= trailingOptionalFields) {
                ArrayList<DamlRecord.Field> newFields = new ArrayList<DamlRecord.Field>(fields);
                for (int i = 0; i < expectedFields - numberOfFields; ++i) {
                    newFields.add(new DamlRecord.Field(DamlOptional.EMPTY));
                }
                logger.trace("Upgrading record, appending {} empty optional fields", (Object)(expectedFields - numberOfFields));
                return newFields;
            }
            throw new IllegalArgumentException("Expected " + expectedFields + " arguments, got " + numberOfFields + " and only the last " + trailingOptionalFields + " of the expected type are optionals");
        }
        return fields;
    }

    public static Value variantCheck(String expectedConstructor, Value variantMaybe) {
        Variant variant = variantMaybe.asVariant().orElseThrow(() -> new IllegalArgumentException("Expected: Variant. Actual: " + variantMaybe.getClass().getName()));
        if (!expectedConstructor.equals(variant.getConstructor())) {
            throw new IllegalArgumentException("Invalid constructor. Expected: " + expectedConstructor + ". Actual: " + variant.getConstructor());
        }
        return variant.getValue();
    }
}

