/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen;

import com.daml.ledger.javaapi.data.Command;
import com.daml.ledger.javaapi.data.codegen.Created;
import com.daml.ledger.javaapi.data.codegen.Exercised;
import com.daml.ledger.javaapi.data.codegen.HasCommands;
import com.daml.ledger.javaapi.data.codegen.ValueDecoder;
import java.util.List;
import java.util.function.Function;

public abstract class Update<U>
implements HasCommands {
    final Command command;

    public Update(Command command) {
        this.command = command;
    }

    @Override
    public final List<Command> commands() {
        return List.of(this.command);
    }

    public abstract <V> Update<V> map(Function<? super U, ? extends V> var1);

    public <Z> Z foldUpdate(FoldUpdate<U, Z> foldUpdate) {
        if (this instanceof CreateUpdate) {
            return foldUpdate.created((CreateUpdate)this);
        }
        if (this instanceof ExerciseUpdate) {
            return foldUpdate.exercised((ExerciseUpdate)this);
        }
        throw new IllegalArgumentException("Unexpected type of Update: " + this);
    }

    public static abstract class FoldUpdate<U, Z> {
        public abstract <CtId> Z created(CreateUpdate<CtId, U> var1);

        public abstract <R> Z exercised(ExerciseUpdate<R, U> var1);
    }

    public static final class CreateUpdate<CtId, U>
    extends Update<U> {
        public final Function<Created<CtId>, U> k;
        public final Function<String, CtId> createdContractId;

        public CreateUpdate(Command command, Function<Created<CtId>, U> k, Function<String, CtId> createdContractId) {
            super(command);
            this.k = k;
            this.createdContractId = createdContractId;
        }

        public <V> CreateUpdate<CtId, V> map(Function<? super U, ? extends V> f) {
            return new CreateUpdate<CtId, V>(this.command, this.k.andThen(f), this.createdContractId);
        }
    }

    public static final class ExerciseUpdate<R, U>
    extends Update<U> {
        public final Function<Exercised<R>, U> k;
        public final ValueDecoder<R> returnTypeDecoder;

        public ExerciseUpdate(Command command, Function<Exercised<R>, U> k, ValueDecoder<R> returnTypeDecoder) {
            super(command);
            this.k = k;
            this.returnTypeDecoder = returnTypeDecoder;
        }

        public <V> ExerciseUpdate<R, V> map(Function<? super U, ? extends V> f) {
            return new ExerciseUpdate<R, V>(this.command, this.k.andThen(f), this.returnTypeDecoder);
        }
    }
}

