/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.TransactionFilterOuterClass;
import com.daml.ledger.javaapi.data.Filter;
import com.daml.ledger.javaapi.data.TransactionFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class FiltersByParty
extends TransactionFilter {
    private Map<String, Filter> partyToFilters;

    @Override
    public Set<String> getParties() {
        return this.partyToFilters.keySet();
    }

    public FiltersByParty(@NonNull Map<@NonNull String, @NonNull Filter> partyToFilters) {
        this.partyToFilters = partyToFilters;
    }

    @Override
    public TransactionFilterOuterClass.TransactionFilter toProto() {
        HashMap<String, TransactionFilterOuterClass.Filters> partyToFilters = new HashMap<String, TransactionFilterOuterClass.Filters>(this.partyToFilters.size());
        for (Map.Entry<String, Filter> entry : this.partyToFilters.entrySet()) {
            partyToFilters.put(entry.getKey(), entry.getValue().toProto());
        }
        return TransactionFilterOuterClass.TransactionFilter.newBuilder().putAllFiltersByParty(partyToFilters).build();
    }

    public static FiltersByParty fromProto(TransactionFilterOuterClass.TransactionFilter transactionFilter) {
        Map<String, TransactionFilterOuterClass.Filters> partyToFilters = transactionFilter.getFiltersByPartyMap();
        HashMap<String, Filter> converted = new HashMap<String, Filter>(partyToFilters.size());
        for (Map.Entry<String, TransactionFilterOuterClass.Filters> entry : partyToFilters.entrySet()) {
            converted.put(entry.getKey(), Filter.fromProto(entry.getValue()));
        }
        return new FiltersByParty(converted);
    }

    public Map<String, Filter> getPartyToFilters() {
        return this.partyToFilters;
    }

    public String toString() {
        return "FiltersByParty{partyToFilters=" + this.partyToFilters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FiltersByParty that = (FiltersByParty)o;
        return Objects.equals(this.partyToFilters, that.partyToFilters);
    }

    public int hashCode() {
        return Objects.hash(this.partyToFilters);
    }
}

