/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class User {
    private final String id;
    private final Optional<String> primaryParty;

    public User(@NonNull String id) {
        this.id = id;
        this.primaryParty = Optional.empty();
    }

    public User(@NonNull String id, @NonNull String primaryParty) {
        this.id = id;
        this.primaryParty = Optional.of(primaryParty);
    }

    public UserManagementServiceOuterClass.User toProto() {
        return UserManagementServiceOuterClass.User.newBuilder().setId(this.id).setPrimaryParty(this.primaryParty.orElse(null)).build();
    }

    public static User fromProto(UserManagementServiceOuterClass.User proto) {
        String id = proto.getId();
        String primaryParty = proto.getPrimaryParty();
        if (primaryParty == null || primaryParty.isEmpty()) {
            return new User(id);
        }
        return new User(id, primaryParty);
    }

    public @NonNull String getId() {
        return this.id;
    }

    public Optional<String> getPrimaryParty() {
        return this.primaryParty;
    }

    public String toString() {
        return "User{id='" + this.id + "'" + this.primaryParty.map(p -> ", primaryParty='" + p + "'").orElse("") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id) && Objects.equals(this.primaryParty, user.primaryParty);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.primaryParty);
    }

    public static abstract class Right {
        abstract UserManagementServiceOuterClass.Right toProto();

        public static Right fromProto(UserManagementServiceOuterClass.Right proto) {
            Right right;
            UserManagementServiceOuterClass.Right.KindCase kindCase = proto.getKindCase();
            switch (kindCase) {
                case CAN_ACT_AS: {
                    right = new CanActAs(proto.getCanActAs().getParty());
                    break;
                }
                case CAN_READ_AS: {
                    right = new CanReadAs(proto.getCanReadAs().getParty());
                    break;
                }
                case PARTICIPANT_ADMIN: {
                    right = ParticipantAdmin.INSTANCE;
                    break;
                }
                case IDENTITY_PROVIDER_ADMIN: {
                    right = IdentityProviderAdmin.INSTANCE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized user right case: " + kindCase.name());
                }
            }
            return right;
        }

        public static final class CanReadAs
        extends Right {
            public final String party;

            public CanReadAs(String party) {
                this.party = party;
            }

            @Override
            UserManagementServiceOuterClass.Right toProto() {
                return UserManagementServiceOuterClass.Right.newBuilder().setCanReadAs(UserManagementServiceOuterClass.Right.CanReadAs.newBuilder().setParty(this.party)).build();
            }
        }

        public static final class CanActAs
        extends Right {
            public final String party;

            public CanActAs(String party) {
                this.party = party;
            }

            @Override
            UserManagementServiceOuterClass.Right toProto() {
                return UserManagementServiceOuterClass.Right.newBuilder().setCanActAs(UserManagementServiceOuterClass.Right.CanActAs.newBuilder().setParty(this.party)).build();
            }
        }

        public static final class ParticipantAdmin
        extends Right {
            public static final ParticipantAdmin INSTANCE = new ParticipantAdmin();

            private ParticipantAdmin() {
            }

            @Override
            UserManagementServiceOuterClass.Right toProto() {
                return UserManagementServiceOuterClass.Right.newBuilder().setParticipantAdmin(UserManagementServiceOuterClass.Right.ParticipantAdmin.getDefaultInstance()).build();
            }
        }

        public static final class IdentityProviderAdmin
        extends Right {
            public static final IdentityProviderAdmin INSTANCE = new IdentityProviderAdmin();

            private IdentityProviderAdmin() {
            }

            @Override
            UserManagementServiceOuterClass.Right toProto() {
                return UserManagementServiceOuterClass.Right.newBuilder().setIdentityProviderAdmin(UserManagementServiceOuterClass.Right.IdentityProviderAdmin.getDefaultInstance()).build();
            }
        }
    }
}

