/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen.json;

import com.daml.ledger.javaapi.data.codegen.json.JsonLfDecoder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

public class JsonLfReader {
    private final String json;
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final JsonParser parser;

    public JsonLfReader(String json) throws JsonLfDecoder.Error {
        this.json = json;
        try {
            this.parser = jsonFactory.createParser(json);
        }
        catch (IOException e) {
            throw new JsonLfDecoder.Error("Failed to create parser", this.locationStart(), e);
        }
        try {
            this.parser.nextToken();
        }
        catch (IOException e) {
            throw new JsonLfDecoder.Error("JSON parse error", this.locationStart(), e);
        }
    }

    protected void missingField(String fieldName) throws JsonLfDecoder.Error {
        throw new JsonLfDecoder.Error(String.format("Missing field %s", fieldName), this.locationStart());
    }

    protected void unknownField(String fieldName, List<String> expected, Location loc) throws JsonLfDecoder.Error {
        UnknownValue.read(this);
        throw new JsonLfDecoder.Error(String.format("Unknown field %s (known fields are %s)", fieldName, expected), loc);
    }

    boolean isStartObject() {
        return this.parser.currentToken() == JsonToken.START_OBJECT;
    }

    boolean notEndObject() {
        return !this.parser.isClosed() && this.parser.currentToken() != JsonToken.END_OBJECT;
    }

    boolean isStartArray() {
        return this.parser.currentToken() == JsonToken.START_ARRAY;
    }

    boolean notEndArray() {
        return !this.parser.isClosed() && this.parser.currentToken() != JsonToken.END_ARRAY;
    }

    boolean isNull() {
        return this.parser.currentToken() == JsonToken.VALUE_NULL;
    }

    void readStartObject() throws JsonLfDecoder.Error {
        this.expectIsAt("{", JsonToken.START_OBJECT);
        this.moveNext();
    }

    void readEndObject() throws JsonLfDecoder.Error {
        this.expectIsAt("}", JsonToken.END_OBJECT);
        this.moveNext();
    }

    void readStartArray() throws JsonLfDecoder.Error {
        this.expectIsAt("[", JsonToken.START_ARRAY);
        this.moveNext();
    }

    void readEndArray() throws JsonLfDecoder.Error {
        this.expectIsAt("]", JsonToken.END_ARRAY);
        this.moveNext();
    }

    FieldName readFieldName() throws JsonLfDecoder.Error {
        this.expectIsAt("field", JsonToken.FIELD_NAME);
        String name = null;
        try {
            name = this.parser.getText();
        }
        catch (IOException e) {
            this.parseExpected("textual field name", e);
        }
        Location loc = this.locationStart();
        this.moveNext();
        return new FieldName(name, loc);
    }

    <T> T readFromText(Function<String, T> interpreter, List<String> expected) throws JsonLfDecoder.Error {
        this.expectIsAt("text", JsonToken.VALUE_STRING);
        String got = null;
        try {
            got = this.parser.getText();
        }
        catch (IOException e) {
            this.parseExpected("valid textual value", e);
        }
        T result = interpreter.apply(got);
        if (result == null) {
            this.parseExpected("one of " + expected);
        }
        this.moveNext();
        return result;
    }

    Location locationStart() {
        JsonLocation loc = this.parser.currentTokenLocation();
        return new Location(loc.getLineNr(), loc.getColumnNr(), (int)loc.getCharOffset());
    }

    Location locationEnd() {
        try {
            this.parser.finishToken();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JsonLocation loc = this.parser.currentLocation();
        return new Location(loc.getLineNr(), loc.getColumnNr(), (int)loc.getCharOffset());
    }

    String currentText(String expected) throws JsonLfDecoder.Error {
        String text = null;
        try {
            text = this.parser.getText();
        }
        catch (IOException e) {
            this.parseExpected(expected, e, "nothing", this.locationStart());
        }
        return text == null ? "nothing" : text;
    }

    void parseExpected(String expected) throws JsonLfDecoder.Error {
        this.parseExpected(expected, null);
    }

    void parseExpected(String expected, Throwable cause) throws JsonLfDecoder.Error {
        this.parseExpected(expected, cause, this.currentText(expected), this.locationStart());
    }

    void parseExpected(String expected, Throwable cause, String actual, Location location) throws JsonLfDecoder.Error {
        String message = String.format("Expected %s but was %s", expected, actual);
        throw new JsonLfDecoder.Error(message, location, cause);
    }

    void expectIsAt(String description, JsonToken ... expected) throws JsonLfDecoder.Error {
        for (int i = 0; i < expected.length; ++i) {
            if (this.parser.currentToken() != expected[i]) continue;
            return;
        }
        this.parseExpected(description);
    }

    JsonLfReader moveNext() throws JsonLfDecoder.Error {
        try {
            this.parser.nextToken();
            return this;
        }
        catch (JsonParseException e) {
            throw new JsonLfDecoder.Error("JSON parse error", this.locationEnd(), e);
        }
        catch (IOException e) {
            throw new JsonLfDecoder.Error(String.format("Read failed", new Object[0]), this.locationEnd(), e);
        }
    }

    class FieldName {
        final String name;
        final Location loc;

        private FieldName(String name, Location loc) {
            this.name = name;
            this.loc = loc;
        }
    }

    public static class UnknownValue {
        private final String jsonRepr;
        private final Location start;

        private UnknownValue(String jsonRepr, Location start) {
            this.jsonRepr = jsonRepr;
            this.start = start;
        }

        public static UnknownValue read(JsonLfReader r) throws JsonLfDecoder.Error {
            Location from = r.locationStart();
            try {
                r.parser.skipChildren();
                Location to = r.locationEnd();
                String repr = r.json.substring(from.charOffset, to.charOffset);
                r.moveNext();
                return new UnknownValue(repr, from);
            }
            catch (IOException e) {
                throw new JsonLfDecoder.Error("cannot read unknown value", r.locationStart(), e);
            }
        }

        public <T> T decodeWith(JsonLfDecoder<T> decoder) throws JsonLfDecoder.Error {
            try {
                return decoder.decode(new JsonLfReader(this.jsonRepr));
            }
            catch (JsonLfDecoder.Error e) {
                throw e.fromStartLocation(this.start);
            }
        }
    }

    public static class Location {
        public final int line;
        public final int column;
        public final int charOffset;

        public Location(int line, int column, int charOffset) {
            this.line = line;
            this.column = column;
            this.charOffset = charOffset;
        }

        public Location advance(Location that) {
            int col = that.line == 1 ? this.column + that.column - 1 : that.column;
            return new Location(this.line + that.line - 1, col, this.charOffset + that.charOffset);
        }
    }
}

