/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.ReassignmentCommandOuterClass;
import com.daml.ledger.javaapi.data.ReassignmentCommand;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class AssignCommand
extends ReassignmentCommand {
    private final @NonNull String reassignmentId;
    private final @NonNull String source;
    private final @NonNull String target;

    public AssignCommand(@NonNull String reassignmentId, @NonNull String source, @NonNull String target) {
        this.reassignmentId = reassignmentId;
        this.source = source;
        this.target = target;
    }

    public @NonNull String getReassignmentId() {
        return this.reassignmentId;
    }

    public @NonNull String getSource() {
        return this.source;
    }

    public @NonNull String getTarget() {
        return this.target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignCommand that = (AssignCommand)o;
        return Objects.equals(this.reassignmentId, that.reassignmentId) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
    }

    public int hashCode() {
        return Objects.hash(this.reassignmentId, this.source, this.target);
    }

    public String toString() {
        return "AssignCommand{reassignmentId='" + this.reassignmentId + "', source=" + this.source + ", target=" + this.target + "}";
    }

    public ReassignmentCommandOuterClass.AssignCommand toProto() {
        return ReassignmentCommandOuterClass.AssignCommand.newBuilder().setReassignmentId(this.reassignmentId).setSource(this.source).setTarget(this.target).build();
    }

    public static AssignCommand fromProto(ReassignmentCommandOuterClass.AssignCommand assignCommand) {
        return new AssignCommand(assignCommand.getReassignmentId(), assignCommand.getSource(), assignCommand.getTarget());
    }
}

