/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.CommandsOuterClass;
import com.daml.ledger.javaapi.data.Command;
import com.daml.ledger.javaapi.data.DisclosedContract;
import com.daml.ledger.javaapi.data.PrefetchContractKey;
import com.daml.ledger.javaapi.data.Utils;
import com.daml.ledger.javaapi.data.codegen.HasCommands;
import com.google.protobuf.ProtocolStringList;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CommandsSubmission {
    private final @NonNull Optional<String> workflowId;
    private final @NonNull String userId;
    private final @NonNull String commandId;
    private final @NonNull List<@NonNull ? extends HasCommands> commands;
    private final @NonNull Optional<Duration> deduplicationDuration;
    private final @NonNull Optional<Long> deduplicationOffset;
    private final @NonNull Optional<Instant> minLedgerTimeAbs;
    private final @NonNull Optional<Duration> minLedgerTimeRel;
    private final @NonNull List<@NonNull String> actAs;
    private final @NonNull List<@NonNull String> readAs;
    private final @NonNull Optional<String> submissionId;
    private final @NonNull List<DisclosedContract> disclosedContracts;
    private final @NonNull Optional<String> synchronizerId;
    private final @NonNull Optional<String> accessToken;
    private @NonNull List<String> packageIdSelectionPreference;
    private @NonNull List<@NonNull PrefetchContractKey> prefetchContractKeys;

    protected CommandsSubmission(@NonNull Optional<String> workflowId, @NonNull String userId, @NonNull String commandId, @NonNull List<@NonNull ? extends HasCommands> commands, @NonNull Optional<Duration> deduplicationDuration, @NonNull Optional<Long> deduplicationOffset, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<String> submissionId, @NonNull List<@NonNull DisclosedContract> disclosedContracts, @NonNull Optional<String> synchronizerId, @NonNull Optional<String> accessToken, @NonNull List<String> packageIdSelectionPreference, @NonNull List<@NonNull PrefetchContractKey> prefetchContractKeys) {
        this.workflowId = workflowId;
        this.userId = userId;
        this.commandId = commandId;
        this.commands = commands;
        this.deduplicationDuration = deduplicationDuration;
        this.deduplicationOffset = deduplicationOffset;
        this.minLedgerTimeAbs = minLedgerTimeAbs;
        this.minLedgerTimeRel = minLedgerTimeRel;
        this.actAs = actAs;
        this.readAs = readAs;
        this.submissionId = submissionId;
        this.disclosedContracts = disclosedContracts;
        this.synchronizerId = synchronizerId;
        this.accessToken = accessToken;
        this.packageIdSelectionPreference = packageIdSelectionPreference;
        this.prefetchContractKeys = prefetchContractKeys;
    }

    public static CommandsSubmission create(String userId, String commandId, Optional<String> synchronizerId, @NonNull List<@NonNull ? extends HasCommands> commands) {
        return new CommandsSubmission(Optional.empty(), userId, commandId, commands, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList(), Collections.emptyList(), Optional.empty(), Collections.emptyList(), synchronizerId, Optional.empty(), Collections.emptyList(), Collections.emptyList());
    }

    public @NonNull Optional<String> getWorkflowId() {
        return this.workflowId;
    }

    public @NonNull List<String> getPackageIdSelectionPreference() {
        return Collections.unmodifiableList(this.packageIdSelectionPreference);
    }

    public @NonNull String getUserId() {
        return this.userId;
    }

    public @NonNull String getCommandId() {
        return this.commandId;
    }

    public @NonNull List<? extends HasCommands> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public @NonNull Optional<Duration> getDeduplicationDuration() {
        return this.deduplicationDuration;
    }

    public @NonNull Optional<Long> getDeduplicationOffset() {
        return this.deduplicationOffset;
    }

    public @NonNull Optional<Instant> getMinLedgerTimeAbs() {
        return this.minLedgerTimeAbs;
    }

    public @NonNull Optional<Duration> getMinLedgerTimeRel() {
        return this.minLedgerTimeRel;
    }

    public @NonNull List<String> getActAs() {
        return Collections.unmodifiableList(this.actAs);
    }

    public @NonNull List<String> getReadAs() {
        return Collections.unmodifiableList(this.readAs);
    }

    public @NonNull Optional<String> getSubmissionId() {
        return this.submissionId;
    }

    public @NonNull List<DisclosedContract> getDisclosedContracts() {
        return Collections.unmodifiableList(this.disclosedContracts);
    }

    public @NonNull Optional<String> getSynchronizerId() {
        return this.synchronizerId;
    }

    public @NonNull Optional<String> getAccessToken() {
        return this.accessToken;
    }

    public List<PrefetchContractKey> getPrefetchContractKeys() {
        return Collections.unmodifiableList(this.prefetchContractKeys);
    }

    public CommandsSubmission withWorkflowId(String workflowId) {
        return new CommandsSubmission(Optional.of(workflowId), this.userId, this.commandId, this.commands, this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.actAs, this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withActAs(String actAs) {
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.commands, this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, List.of(actAs), this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withActAs(List<@NonNull String> actAs) {
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.commands, this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, actAs, this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withReadAs(List<@NonNull String> readAs) {
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.commands, this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.actAs, readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withMinLedgerTimeAbs(@NonNull Instant minLedgerTimeAbs) {
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.commands, this.deduplicationDuration, this.deduplicationOffset, Optional.of(minLedgerTimeAbs), this.minLedgerTimeRel, this.actAs, this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withMinLedgerTimeRel(@NonNull Duration minLedgerTimeRel) {
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.commands, this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, Optional.of(minLedgerTimeRel), this.actAs, this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withDeduplicationDuration(@NonNull Duration deduplicationDuration) throws RedundantDeduplicationSpecification {
        this.deduplicationOffset.ifPresent(offset -> {
            throw new RedundantDeduplicationSpecification(deduplicationDuration, (Long)offset);
        });
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.commands, Optional.of(deduplicationDuration), this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.actAs, this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withDeduplicationOffset(@NonNull Long deduplicationOffset) throws RedundantDeduplicationSpecification {
        this.deduplicationDuration.ifPresent(duration -> {
            throw new RedundantDeduplicationSpecification((Duration)duration, deduplicationOffset);
        });
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.commands, this.deduplicationDuration, Optional.of(deduplicationOffset), this.minLedgerTimeAbs, this.minLedgerTimeRel, this.actAs, this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withCommands(List<@NonNull ? extends HasCommands> commands) {
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, commands, this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.actAs, this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withAccessToken(@NonNull String accessToken) {
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.commands, this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.actAs, this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, Optional.of(accessToken), this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withDisclosedContracts(List<@NonNull DisclosedContract> disclosedContracts) {
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.commands, this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.actAs, this.readAs, this.submissionId, disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withPackageIdSelectionPreference(List<@NonNull String> packageIdSelectionPreference) {
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.commands, this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.actAs, this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public CommandsSubmission withPrefetchContractKeys(@NonNull List<@NonNull PrefetchContractKey> prefetchContractKeys) {
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.commands, this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.actAs, this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, prefetchContractKeys);
    }

    public CommandsOuterClass.Commands toProto() {
        if (this.actAs.isEmpty()) {
            throw new IllegalArgumentException("actAs must have at least one element");
        }
        List commandsConverted = HasCommands.toCommands(this.commands).stream().map(Command::toProtoCommand).collect(Collectors.toList());
        List disclosedContractsConverted = this.disclosedContracts.stream().map(DisclosedContract::toProto).collect(Collectors.toList());
        CommandsOuterClass.Commands.Builder builder = CommandsOuterClass.Commands.newBuilder().setUserId(this.userId).setCommandId(this.commandId).addAllCommands(commandsConverted).addAllActAs(this.actAs).addAllReadAs(this.readAs).addAllDisclosedContracts(disclosedContractsConverted).addAllPackageIdSelectionPreference(this.packageIdSelectionPreference);
        this.synchronizerId.ifPresent(builder::setSynchronizerId);
        this.workflowId.ifPresent(builder::setWorkflowId);
        this.deduplicationDuration.ifPresent(dedup -> builder.setDeduplicationDuration(Utils.durationToProto(dedup)));
        this.deduplicationOffset.ifPresent(builder::setDeduplicationOffset);
        this.minLedgerTimeAbs.ifPresent(abs -> builder.setMinLedgerTimeAbs(Utils.instantToProto(abs)));
        this.minLedgerTimeRel.ifPresent(rel -> builder.setMinLedgerTimeRel(Utils.durationToProto(rel)));
        this.submissionId.ifPresent(builder::setSubmissionId);
        return builder.build();
    }

    public static CommandsSubmission fromProto(CommandsOuterClass.Commands commands) {
        Optional<String> workflowId = commands.getWorkflowId().isEmpty() ? Optional.empty() : Optional.of(commands.getWorkflowId());
        String userId = commands.getUserId();
        String commandId = commands.getCommandId();
        Optional<String> synchronizerId = commands.getSynchronizerId().isEmpty() ? Optional.empty() : Optional.of(commands.getSynchronizerId());
        List listOfCommands = commands.getCommandsList().stream().map(Command::fromProtoCommand).collect(Collectors.toList());
        Optional<Duration> deduplicationDuration = commands.hasDeduplicationDuration() ? Optional.of(Utils.durationFromProto(commands.getDeduplicationDuration())) : Optional.empty();
        Optional<Long> deduplicationOffset = commands.hasDeduplicationOffset() ? Optional.of(commands.getDeduplicationOffset()) : Optional.empty();
        Optional<Instant> minLedgerTimeAbs = commands.hasMinLedgerTimeAbs() ? Optional.of(Utils.instantFromProto(commands.getMinLedgerTimeAbs())) : Optional.empty();
        Optional<Duration> minLedgerTimeRel = commands.hasMinLedgerTimeRel() ? Optional.of(Utils.durationFromProto(commands.getMinLedgerTimeRel())) : Optional.empty();
        ProtocolStringList actAs = commands.getActAsList();
        ProtocolStringList readAs = commands.getReadAsList();
        Optional<String> submissionId = commands.getSubmissionId().isEmpty() ? Optional.empty() : Optional.of(commands.getSubmissionId());
        List<DisclosedContract> disclosedContracts = commands.getDisclosedContractsList().stream().map(DisclosedContract::fromProto).collect(Collectors.toList());
        ProtocolStringList packageIdSelectionPreference = commands.getPackageIdSelectionPreferenceList();
        List<PrefetchContractKey> prefetchContractKeys = commands.getPrefetchContractKeysList().stream().map(PrefetchContractKey::fromProto).collect(Collectors.toList());
        return new CommandsSubmission(workflowId, userId, commandId, listOfCommands, deduplicationDuration, deduplicationOffset, minLedgerTimeAbs, minLedgerTimeRel, (List<String>)actAs, (List<String>)readAs, submissionId, disclosedContracts, synchronizerId, Optional.empty(), (List<String>)packageIdSelectionPreference, prefetchContractKeys);
    }

    public String toString() {
        return "CommandsSubmission{workflowId='" + this.workflowId + "', userId='" + this.userId + "', commandId='" + this.commandId + "', commands=" + this.commands + ", deduplicationDuration=" + this.deduplicationDuration + ", deduplicationOffset=" + this.deduplicationOffset + ", minLedgerTimeAbs=" + this.minLedgerTimeAbs + ", minLedgerTimeRel=" + this.minLedgerTimeRel + ", actAs=" + this.actAs + ", readAs=" + this.readAs + ", submissionId=" + this.submissionId + ", disclosedContracts=" + this.disclosedContracts + ", synchronizerId='" + this.synchronizerId + "', accessToken=" + this.accessToken + "', packageIdSelectionPreference=" + this.packageIdSelectionPreference + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandsSubmission commandsSubmission = (CommandsSubmission)o;
        return Objects.equals(this.workflowId, commandsSubmission.workflowId) && Objects.equals(this.userId, commandsSubmission.userId) && Objects.equals(this.commandId, commandsSubmission.commandId) && Objects.equals(this.commands, commandsSubmission.commands) && Objects.equals(this.deduplicationDuration, commandsSubmission.deduplicationDuration) && Objects.equals(this.deduplicationOffset, commandsSubmission.deduplicationOffset) && Objects.equals(this.minLedgerTimeAbs, commandsSubmission.minLedgerTimeAbs) && Objects.equals(this.minLedgerTimeRel, commandsSubmission.minLedgerTimeRel) && Objects.equals(this.actAs, commandsSubmission.actAs) && Objects.equals(this.readAs, commandsSubmission.readAs) && Objects.equals(this.submissionId, commandsSubmission.submissionId) && Objects.equals(this.disclosedContracts, commandsSubmission.disclosedContracts) && Objects.equals(this.synchronizerId, commandsSubmission.synchronizerId) && Objects.equals(this.accessToken, commandsSubmission.accessToken) && Objects.equals(this.packageIdSelectionPreference, commandsSubmission.packageIdSelectionPreference);
    }

    public int hashCode() {
        return Objects.hash(this.workflowId, this.userId, this.commandId, this.commands, this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.actAs, this.readAs, this.submissionId, this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference);
    }

    public static class RedundantDeduplicationSpecification
    extends RuntimeException {
        public RedundantDeduplicationSpecification(Duration deduplicationDuration, Long deduplicationOffset) {
            super("Both a deduplicationDuration: " + deduplicationDuration.toString() + " and a deduplicationOffset: " + deduplicationOffset.toString() + " given");
        }
    }
}

