/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.CompletionOuterClass;
import com.daml.ledger.api.v2.TraceContextOuterClass;
import com.daml.ledger.javaapi.data.SynchronizerTime;
import com.daml.ledger.javaapi.data.Utils;
import com.google.rpc.Status;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Completion {
    private final @NonNull String commandId;
    private final @NonNull Status status;
    private final @NonNull String updateId;
    private final @NonNull String userId;
    private final @NonNull List<@NonNull String> actAs;
    private final @NonNull String submissionId;
    private final @NonNull Optional<Long> deduplicationOffset;
    private final @NonNull Optional<Duration> deduplicationDuration;
    private final @NonNull TraceContextOuterClass.TraceContext traceContext;
    private final @NonNull Long offset;
    private final @NonNull SynchronizerTime synchronizerTime;

    private Completion(@NonNull String commandId, @NonNull Status status, @NonNull String updateId, @NonNull String userId, @NonNull List<@NonNull String> actAs, @NonNull String submissionId, @NonNull Optional<Long> deduplicationOffset, @NonNull Optional<Duration> deduplicationDuration, @NonNull TraceContextOuterClass.TraceContext traceContext, @NonNull Long offset, @NonNull SynchronizerTime synchronizerTime) {
        this.commandId = commandId;
        this.status = status;
        this.updateId = updateId;
        this.userId = userId;
        this.actAs = List.copyOf(actAs);
        this.submissionId = submissionId;
        this.deduplicationOffset = deduplicationOffset;
        this.deduplicationDuration = deduplicationDuration;
        this.traceContext = traceContext;
        this.offset = offset;
        this.synchronizerTime = synchronizerTime;
    }

    public Completion(@NonNull String commandId, @NonNull Status status, @NonNull String updateId, @NonNull String userId, @NonNull List<@NonNull String> actAs, @NonNull String submissionId, @NonNull Long deduplicationOffset, TraceContextOuterClass.TraceContext traceContext, @NonNull Long offset, @NonNull SynchronizerTime synchronizerTime) {
        this(commandId, status, updateId, userId, actAs, submissionId, Optional.of(deduplicationOffset), Optional.empty(), traceContext, offset, synchronizerTime);
    }

    public Completion(@NonNull String commandId, @NonNull Status status, @NonNull String updateId, @NonNull String userId, @NonNull List<@NonNull String> actAs, @NonNull String submissionId, @NonNull Duration deduplicationDuration, TraceContextOuterClass.TraceContext traceContext, @NonNull Long offset, @NonNull SynchronizerTime synchronizerTime) {
        this(commandId, status, updateId, userId, actAs, submissionId, Optional.empty(), Optional.of(deduplicationDuration), traceContext, offset, synchronizerTime);
    }

    public @NonNull String getCommandId() {
        return this.commandId;
    }

    public @NonNull Status getStatus() {
        return this.status;
    }

    public @NonNull String getUpdateId() {
        return this.updateId;
    }

    public @NonNull String getUserId() {
        return this.userId;
    }

    public @NonNull List<@NonNull String> getActAs() {
        return this.actAs;
    }

    public @NonNull String getSubmissionId() {
        return this.submissionId;
    }

    public @NonNull Optional<Long> getDeduplicationOffset() {
        return this.deduplicationOffset;
    }

    public @NonNull Optional<Duration> getDeduplicationDuration() {
        return this.deduplicationDuration;
    }

    public @NonNull TraceContextOuterClass.TraceContext getTraceContext() {
        return this.traceContext;
    }

    public @NonNull Long getOffset() {
        return this.offset;
    }

    public @NonNull SynchronizerTime getSynchronizerTime() {
        return this.synchronizerTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Completion that = (Completion)o;
        return Objects.equals(this.commandId, that.commandId) && Objects.equals(this.status, that.status) && Objects.equals(this.updateId, that.updateId) && Objects.equals(this.userId, that.userId) && Objects.equals(this.actAs, that.actAs) && Objects.equals(this.submissionId, that.submissionId) && Objects.equals(this.deduplicationOffset, that.deduplicationOffset) && Objects.equals(this.deduplicationDuration, that.deduplicationDuration) && Objects.equals(this.traceContext, that.traceContext) && Objects.equals(this.offset, that.offset) && Objects.equals(this.synchronizerTime, that.synchronizerTime);
    }

    public int hashCode() {
        return Objects.hash(this.commandId, this.status, this.updateId, this.userId, this.actAs, this.submissionId, this.deduplicationOffset, this.deduplicationDuration, this.traceContext, this.offset, this.synchronizerTime);
    }

    public String toString() {
        return "Completion{commandId='" + this.commandId + "', status=" + this.status + ", updateId='" + this.updateId + "', userId=" + this.userId + ", actAs=" + this.actAs + ", submissionId=" + this.submissionId + ", deduplicationOffset=" + this.deduplicationOffset + ", deduplicationDuration=" + this.deduplicationDuration + ", traceContext=" + this.traceContext + ", offset='" + this.offset + ", synchronizerTime=" + this.synchronizerTime + "'}";
    }

    public CompletionOuterClass.Completion toProto() {
        CompletionOuterClass.Completion.Builder builder = CompletionOuterClass.Completion.newBuilder().setCommandId(this.commandId).setStatus(this.status).setUpdateId(this.updateId).setUserId(this.userId).addAllActAs(this.actAs).setSubmissionId(this.submissionId).setTraceContext(this.traceContext).setOffset(this.offset).setSynchronizerTime(this.synchronizerTime.toProto());
        this.deduplicationOffset.ifPresent(builder::setDeduplicationOffset);
        this.deduplicationDuration.ifPresent(duration -> builder.setDeduplicationDuration(Utils.durationToProto(duration)));
        return builder.build();
    }

    public static Completion fromProto(CompletionOuterClass.Completion completion) {
        return new Completion(completion.getCommandId(), completion.getStatus(), completion.getUpdateId(), completion.getUserId(), (List<String>)completion.getActAsList(), completion.getSubmissionId(), completion.hasDeduplicationOffset() ? Optional.of(completion.getDeduplicationOffset()) : Optional.empty(), completion.hasDeduplicationDuration() ? Optional.of(Utils.durationFromProto(completion.getDeduplicationDuration())) : Optional.empty(), completion.getTraceContext(), completion.getOffset(), SynchronizerTime.fromProto(completion.getSynchronizerTime()));
    }
}

