/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.CommandCompletionServiceOuterClass;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CompletionStreamRequest {
    private final @NonNull String userId;
    private final @NonNull List<@NonNull String> parties;
    private final @NonNull Long beginExclusive;

    public CompletionStreamRequest(@NonNull String userId, @NonNull List<@NonNull String> parties, @NonNull Long beginExclusive) {
        this.userId = userId;
        this.parties = List.copyOf(parties);
        this.beginExclusive = beginExclusive;
    }

    public @NonNull String getUserId() {
        return this.userId;
    }

    public @NonNull List<@NonNull String> getParties() {
        return this.parties;
    }

    public Long getBeginExclusive() {
        return this.beginExclusive;
    }

    public static CompletionStreamRequest fromProto(CommandCompletionServiceOuterClass.CompletionStreamRequest request) {
        return new CompletionStreamRequest(request.getUserId(), (List<String>)request.getPartiesList(), request.getBeginExclusive());
    }

    public CommandCompletionServiceOuterClass.CompletionStreamRequest toProto() {
        CommandCompletionServiceOuterClass.CompletionStreamRequest.Builder builder = CommandCompletionServiceOuterClass.CompletionStreamRequest.newBuilder().setUserId(this.userId).addAllParties(this.parties).setBeginExclusive(this.beginExclusive);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletionStreamRequest that = (CompletionStreamRequest)o;
        return Objects.equals(this.userId, that.userId) && Objects.equals(this.parties, that.parties) && Objects.equals(this.beginExclusive, that.beginExclusive);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.parties, this.beginExclusive);
    }

    public String toString() {
        return "CompletionStreamRequest{userId=" + this.userId + ", parties=" + this.parties + ", beginExclusive=" + this.beginExclusive + "}";
    }
}

