/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.CommandCompletionServiceOuterClass;
import com.daml.ledger.javaapi.data.Completion;
import com.daml.ledger.javaapi.data.OffsetCheckpoint;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CompletionStreamResponse {
    private final @NonNull Optional<Completion> completion;
    private final @NonNull Optional<OffsetCheckpoint> offsetCheckpoint;

    public CompletionStreamResponse(@NonNull Optional<Completion> completion, @NonNull Optional<OffsetCheckpoint> offsetCheckpoint) {
        this.completion = completion;
        this.offsetCheckpoint = offsetCheckpoint;
    }

    public CompletionStreamResponse(@NonNull Completion completion) {
        this(Optional.of(completion), Optional.empty());
    }

    public CompletionStreamResponse(@NonNull OffsetCheckpoint offsetCheckpoint) {
        this(Optional.empty(), Optional.of(offsetCheckpoint));
    }

    public @NonNull Optional<Completion> getCompletion() {
        return this.completion;
    }

    public @NonNull Optional<OffsetCheckpoint> getOffsetCheckpoint() {
        return this.offsetCheckpoint;
    }

    public static CompletionStreamResponse fromProto(CommandCompletionServiceOuterClass.CompletionStreamResponse response) {
        return new CompletionStreamResponse(response.hasCompletion() ? Optional.of(Completion.fromProto(response.getCompletion())) : Optional.empty(), response.hasOffsetCheckpoint() ? Optional.of(OffsetCheckpoint.fromProto(response.getOffsetCheckpoint())) : Optional.empty());
    }

    public CommandCompletionServiceOuterClass.CompletionStreamResponse toProto() {
        CommandCompletionServiceOuterClass.CompletionStreamResponse.Builder builder = CommandCompletionServiceOuterClass.CompletionStreamResponse.newBuilder();
        this.completion.ifPresent(c -> builder.setCompletion(c.toProto()));
        this.offsetCheckpoint.ifPresent(c -> builder.setOffsetCheckpoint(c.toProto()));
        return builder.build();
    }

    public String toString() {
        return "CompletionStreamResponse{completion=" + this.completion + ", offsetCheckpoint=" + this.offsetCheckpoint + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletionStreamResponse that = (CompletionStreamResponse)o;
        return Objects.equals(this.completion, that.completion) && Objects.equals(this.offsetCheckpoint, that.offsetCheckpoint);
    }

    public int hashCode() {
        return Objects.hash(this.completion, this.offsetCheckpoint);
    }
}

