/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.StateServiceOuterClass;
import com.daml.ledger.javaapi.data.ParticipantPermission;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ConnectedSynchronizer {
    private final @NonNull String synchronizerAlias;
    private final @NonNull String synchronizerId;
    private final @NonNull ParticipantPermission permission;

    public ConnectedSynchronizer(@NonNull String synchronizerAlias, @NonNull String synchronizerId, @NonNull ParticipantPermission permission) {
        this.synchronizerAlias = synchronizerAlias;
        this.synchronizerId = synchronizerId;
        this.permission = permission;
    }

    @NonNull String getSynchronizerAlias() {
        return this.synchronizerAlias;
    }

    @NonNull String getSynchronizerId() {
        return this.synchronizerId;
    }

    @NonNull ParticipantPermission getPermission() {
        return this.permission;
    }

    public static ConnectedSynchronizer fromProto(StateServiceOuterClass.GetConnectedSynchronizersResponse.ConnectedSynchronizer synchronizer) {
        return new ConnectedSynchronizer(synchronizer.getSynchronizerAlias(), synchronizer.getSynchronizerId(), ParticipantPermission.fromProto(synchronizer.getPermission()));
    }

    public StateServiceOuterClass.GetConnectedSynchronizersResponse.ConnectedSynchronizer toProto() {
        return StateServiceOuterClass.GetConnectedSynchronizersResponse.ConnectedSynchronizer.newBuilder().setSynchronizerAlias(this.synchronizerAlias).setSynchronizerId(this.synchronizerId).setPermission(this.permission.toProto()).build();
    }

    public String toString() {
        return "ConnectedSynchronizer{synchronizerAlias=" + this.synchronizerAlias + ", synchronizerId='" + this.synchronizerId + "', permission=" + this.permission + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectedSynchronizer that = (ConnectedSynchronizer)o;
        return Objects.equals(this.synchronizerAlias, that.synchronizerAlias) && Objects.equals(this.synchronizerId, that.synchronizerId) && Objects.equals(this.permission, that.permission);
    }

    public int hashCode() {
        return Objects.hash(this.synchronizerAlias, this.synchronizerId, this.permission);
    }
}

