/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.TransactionFilterOuterClass;
import com.daml.ledger.javaapi.data.Filter;
import com.daml.ledger.javaapi.data.Identifier;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CumulativeFilter
extends Filter {
    private Map<@NonNull Identifier, @NonNull Filter.Interface> interfaceFilters;
    private Map<@NonNull Identifier, @NonNull Filter.Template> templateFilters;
    private Optional<@NonNull Filter.Wildcard> wildcardFilter;

    public CumulativeFilter(@NonNull Map<@NonNull Identifier, @NonNull Filter.Interface> interfaceFilters, @NonNull Map<@NonNull Identifier, @NonNull Filter.Template> templateFilters, Optional<@NonNull Filter.Wildcard> wildcardFilter) {
        this.interfaceFilters = interfaceFilters;
        this.templateFilters = templateFilters;
        this.wildcardFilter = wildcardFilter;
    }

    public @NonNull Map<@NonNull Identifier, @NonNull Filter.Interface> getInterfaceFilters() {
        return this.interfaceFilters;
    }

    public @NonNull Map<@NonNull Identifier, @NonNull Filter.Template> getTemplateFilters() {
        return this.templateFilters;
    }

    public @NonNull Optional<@NonNull Filter.Wildcard> getWildcardFilter() {
        return this.wildcardFilter;
    }

    @Override
    public TransactionFilterOuterClass.Filters toProto() {
        Iterable ifaces = this.interfaceFilters.entrySet().stream().map(idFilt -> ((Filter.Interface)((Object)((Object)idFilt.getValue()))).toProto((Identifier)idFilt.getKey())).collect(Collectors.toUnmodifiableList());
        Iterable templates = this.templateFilters.entrySet().stream().map(templateFilter -> ((Filter.Template)((Object)((Object)templateFilter.getValue()))).toProto((Identifier)templateFilter.getKey())).collect(Collectors.toUnmodifiableList());
        Iterable wildcard = this.wildcardFilter.map(w -> Collections.singletonList(w.toProto())).orElse(Collections.emptyList());
        Stream<TransactionFilterOuterClass.CumulativeFilter> cumulativeIfaces = StreamSupport.stream(ifaces.spliterator(), false).map(ifaceF -> TransactionFilterOuterClass.CumulativeFilter.newBuilder().setInterfaceFilter((TransactionFilterOuterClass.InterfaceFilter)ifaceF).build());
        Stream<TransactionFilterOuterClass.CumulativeFilter> cumulativeTemplates = StreamSupport.stream(templates.spliterator(), false).map(tempF -> TransactionFilterOuterClass.CumulativeFilter.newBuilder().setTemplateFilter((TransactionFilterOuterClass.TemplateFilter)tempF).build());
        Stream<TransactionFilterOuterClass.CumulativeFilter> cumulativeWildcard = StreamSupport.stream(wildcard.spliterator(), false).map(wildF -> TransactionFilterOuterClass.CumulativeFilter.newBuilder().setWildcardFilter((TransactionFilterOuterClass.WildcardFilter)wildF).build());
        Iterable cumulativeFilters = Stream.concat(Stream.concat(cumulativeIfaces, cumulativeTemplates), cumulativeWildcard).collect(Collectors.toUnmodifiableList());
        return TransactionFilterOuterClass.Filters.newBuilder().addAllCumulative(cumulativeFilters).build();
    }

    public static CumulativeFilter fromProto(Iterable<TransactionFilterOuterClass.CumulativeFilter> cumulativeFilters) {
        Stream<TransactionFilterOuterClass.InterfaceFilter> intrefaceStream = StreamSupport.stream(cumulativeFilters.spliterator(), false).filter(f -> f.hasInterfaceFilter()).map(f -> f.getInterfaceFilter());
        Map<Identifier, Filter.Interface> interfaceIds = intrefaceStream.collect(Collectors.toUnmodifiableMap(ifFilt -> Identifier.fromProto(ifFilt.getInterfaceId()), Filter.Interface::fromProto, Filter.Interface::merge));
        Stream<TransactionFilterOuterClass.TemplateFilter> templateStream = StreamSupport.stream(cumulativeFilters.spliterator(), false).filter(f -> f.hasTemplateFilter()).map(f -> f.getTemplateFilter());
        Map<Identifier, Filter.Template> templateFilters = templateStream.collect(Collectors.toUnmodifiableMap(templateFilter -> Identifier.fromProto(templateFilter.getTemplateId()), Filter.Template::fromProto, Filter.Template::merge));
        Optional<Filter.Wildcard> wildcardFilter = StreamSupport.stream(cumulativeFilters.spliterator(), false).filter(f -> f.hasWildcardFilter()).map(f -> f.getWildcardFilter()).map(Filter.Wildcard::fromProto).reduce(Filter.Wildcard::merge);
        return new CumulativeFilter(interfaceIds, templateFilters, wildcardFilter);
    }

    public String toString() {
        return "CumulativeFilter{interfaceFilters=" + this.interfaceFilters + ", templateFilters=" + this.templateFilters + ", wildcardFilter=" + this.wildcardFilter + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CumulativeFilter that = (CumulativeFilter)o;
        return Objects.equals(this.interfaceFilters, that.interfaceFilters) && Objects.equals(this.templateFilters, that.templateFilters) && Objects.equals(this.wildcardFilter, that.wildcardFilter);
    }

    public int hashCode() {
        return Objects.hash(this.interfaceFilters, this.templateFilters, this.wildcardFilter);
    }
}

