/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.StateServiceOuterClass;
import com.daml.ledger.javaapi.data.EventFormat;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GetActiveContractsRequest {
    private final @NonNull EventFormat eventFormat;
    private final @NonNull Long activeAtOffset;

    public GetActiveContractsRequest(@NonNull EventFormat eventFormat, @NonNull Long activeAtOffset) {
        this.eventFormat = eventFormat;
        this.activeAtOffset = activeAtOffset;
    }

    public static GetActiveContractsRequest fromProto(StateServiceOuterClass.GetActiveContractsRequest request) {
        if (request.hasEventFormat()) {
            return new GetActiveContractsRequest(EventFormat.fromProto(request.getEventFormat()), request.getActiveAtOffset());
        }
        throw new IllegalArgumentException("Request has no eventFormat defined.");
    }

    public StateServiceOuterClass.GetActiveContractsRequest toProto() {
        return StateServiceOuterClass.GetActiveContractsRequest.newBuilder().setEventFormat(this.eventFormat.toProto()).setActiveAtOffset(this.activeAtOffset).build();
    }

    public @NonNull Long getActiveAtOffset() {
        return this.activeAtOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetActiveContractsRequest that = (GetActiveContractsRequest)o;
        return Objects.equals(this.eventFormat, that.eventFormat) && Objects.equals(this.activeAtOffset, that.activeAtOffset);
    }

    public int hashCode() {
        return Objects.hash(this.eventFormat, this.activeAtOffset);
    }

    public String toString() {
        return "GetActiveContractsRequest{eventFormat=" + this.eventFormat + ", activeAtOffset='" + this.activeAtOffset + "'}";
    }
}

