/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.EventQueryServiceOuterClass;
import com.daml.ledger.javaapi.data.ArchivedEvent;
import com.daml.ledger.javaapi.data.CreatedEvent;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GetEventsByContractIdResponse {
    private final @NonNull Optional<Created> created;
    private final @NonNull Optional<Archived> archived;

    public GetEventsByContractIdResponse(@NonNull Optional<Created> created, @NonNull Optional<Archived> archived) {
        this.created = created;
        this.archived = archived;
    }

    public Optional<Created> getCreated() {
        return this.created;
    }

    public Optional<Archived> getArchived() {
        return this.archived;
    }

    public static GetEventsByContractIdResponse fromProto(EventQueryServiceOuterClass.GetEventsByContractIdResponse response) {
        return new GetEventsByContractIdResponse(response.hasCreated() ? Optional.of(Created.fromProto(response.getCreated())) : Optional.empty(), response.hasArchived() ? Optional.of(Archived.fromProto(response.getArchived())) : Optional.empty());
    }

    public EventQueryServiceOuterClass.GetEventsByContractIdResponse toProto() {
        EventQueryServiceOuterClass.GetEventsByContractIdResponse.Builder builder = EventQueryServiceOuterClass.GetEventsByContractIdResponse.newBuilder();
        this.created.ifPresent(created -> builder.setCreated(created.toProto()));
        this.archived.ifPresent(archived -> builder.setArchived(archived.toProto()));
        return builder.build();
    }

    public String toString() {
        return "GetEventsByContractIdResponse{created=" + this.created + ", archived=" + this.archived + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetEventsByContractIdResponse that = (GetEventsByContractIdResponse)o;
        return Objects.equals(this.created, that.created) && Objects.equals(this.archived, that.archived);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.archived);
    }

    public static final class Created {
        private final @NonNull CreatedEvent createdEvent;
        private final @NonNull String synchronizerId;

        public Created(@NonNull CreatedEvent createdEvent, @NonNull String synchronizerId) {
            this.createdEvent = createdEvent;
            this.synchronizerId = synchronizerId;
        }

        public @NonNull CreatedEvent getCreateEvent() {
            return this.createdEvent;
        }

        public @NonNull String getSynchronizerId() {
            return this.synchronizerId;
        }

        public static Created fromProto(EventQueryServiceOuterClass.Created created) {
            return new Created(CreatedEvent.fromProto(created.getCreatedEvent()), created.getSynchronizerId());
        }

        public EventQueryServiceOuterClass.Created toProto() {
            return EventQueryServiceOuterClass.Created.newBuilder().setCreatedEvent(this.createdEvent.toProto()).setSynchronizerId(this.synchronizerId).build();
        }

        public String toString() {
            return "Created{createdEvent=" + this.createdEvent + ", synchronizerId='" + this.synchronizerId + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Created that = (Created)o;
            return Objects.equals(this.createdEvent, that.createdEvent) && Objects.equals(this.synchronizerId, that.synchronizerId);
        }

        public int hashCode() {
            return Objects.hash(this.createdEvent, this.synchronizerId);
        }
    }

    public static final class Archived {
        private final @NonNull ArchivedEvent archivedEvent;
        private final @NonNull String synchronizerId;

        public Archived(@NonNull ArchivedEvent archivedEvent, @NonNull String synchronizerId) {
            this.archivedEvent = archivedEvent;
            this.synchronizerId = synchronizerId;
        }

        public @NonNull ArchivedEvent getArchivedEvent() {
            return this.archivedEvent;
        }

        public @NonNull String getSynchronizerId() {
            return this.synchronizerId;
        }

        public static Archived fromProto(EventQueryServiceOuterClass.Archived archived) {
            return new Archived(ArchivedEvent.fromProto(archived.getArchivedEvent()), archived.getSynchronizerId());
        }

        public EventQueryServiceOuterClass.Archived toProto() {
            return EventQueryServiceOuterClass.Archived.newBuilder().setArchivedEvent(this.archivedEvent.toProto()).setSynchronizerId(this.synchronizerId).build();
        }

        public String toString() {
            return "Archived{archivedEvent=" + this.archivedEvent + ", synchronizerId='" + this.synchronizerId + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Archived that = (Archived)o;
            return Objects.equals(this.archivedEvent, that.archivedEvent) && Objects.equals(this.synchronizerId, that.synchronizerId);
        }

        public int hashCode() {
            return Objects.hash(this.archivedEvent, this.synchronizerId);
        }
    }
}

