/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.interactive.InteractiveSubmissionServiceOuterClass;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GetPreferredPackageVersionRequest {
    private final @NonNull List<@NonNull String> parties;
    private final @NonNull String packageName;
    private final @NonNull Optional<String> synchronizerId;
    private final @NonNull Optional<Instant> vettingValidAt;

    public GetPreferredPackageVersionRequest(@NonNull List<@NonNull String> parties, @NonNull String packageName, @NonNull Optional<String> synchronizerId, @NonNull Optional<Instant> vettingValidAt) {
        this.parties = parties;
        this.packageName = packageName;
        this.synchronizerId = synchronizerId;
        this.vettingValidAt = vettingValidAt;
    }

    public static GetPreferredPackageVersionRequest fromProto(InteractiveSubmissionServiceOuterClass.GetPreferredPackageVersionRequest request) {
        return new GetPreferredPackageVersionRequest((List<String>)request.getPartiesList(), request.getPackageName(), Optional.of(request.getSynchronizerId()).filter(s -> !s.isEmpty()), request.hasVettingValidAt() ? Optional.of(Instant.ofEpochSecond(request.getVettingValidAt().getSeconds(), request.getVettingValidAt().getNanos())) : Optional.empty());
    }

    public InteractiveSubmissionServiceOuterClass.GetPreferredPackageVersionRequest toProto() {
        InteractiveSubmissionServiceOuterClass.GetPreferredPackageVersionRequest.Builder builder = InteractiveSubmissionServiceOuterClass.GetPreferredPackageVersionRequest.newBuilder();
        builder.addAllParties(this.parties);
        builder.setPackageName(this.packageName);
        this.synchronizerId.ifPresent(builder::setSynchronizerId);
        this.vettingValidAt.ifPresent(instant -> builder.setVettingValidAt(Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build()));
        return builder.build();
    }

    public @NonNull List<@NonNull String> getParties() {
        return this.parties;
    }

    public @NonNull String getPackageName() {
        return this.packageName;
    }

    public @NonNull Optional<String> getSynchronizerId() {
        return this.synchronizerId;
    }

    public @NonNull Optional<Instant> getVettingValidAt() {
        return this.vettingValidAt;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPreferredPackageVersionRequest that = (GetPreferredPackageVersionRequest)o;
        return Objects.deepEquals(this.parties, that.parties) && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.synchronizerId, that.synchronizerId) && Objects.equals(this.vettingValidAt, that.vettingValidAt);
    }

    public int hashCode() {
        return Objects.hash(this.parties, this.packageName, this.synchronizerId, this.vettingValidAt);
    }

    public String toString() {
        return "GetPreferredPackageVersionRequest{parties=" + this.parties + ", packageName=" + this.packageName + ", synchronizerId=" + this.synchronizerId + ", vettingValidAt=" + this.vettingValidAt + "}";
    }
}

