/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.interactive.InteractiveSubmissionServiceOuterClass;
import com.daml.ledger.javaapi.data.PackageVettingRequirement;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GetPreferredPackagesRequest {
    private final @NonNull List<@NonNull PackageVettingRequirement> packageVettingRequirements;
    private final @NonNull Optional<String> synchronizerId;
    private final @NonNull Optional<Instant> vettingValidAt;

    public GetPreferredPackagesRequest(@NonNull List<@NonNull PackageVettingRequirement> packageVettingRequirements, @NonNull Optional<String> synchronizerId, @NonNull Optional<Instant> vettingValidAt) {
        this.packageVettingRequirements = packageVettingRequirements;
        this.synchronizerId = synchronizerId;
        this.vettingValidAt = vettingValidAt;
    }

    public static GetPreferredPackagesRequest fromProto(InteractiveSubmissionServiceOuterClass.GetPreferredPackagesRequest request) {
        return new GetPreferredPackagesRequest(request.getPackageVettingRequirementsList().stream().map(PackageVettingRequirement::fromProto).toList(), Optional.of(request.getSynchronizerId()).filter(s -> !s.isEmpty()), request.hasVettingValidAt() ? Optional.of(Instant.ofEpochSecond(request.getVettingValidAt().getSeconds(), request.getVettingValidAt().getNanos())) : Optional.empty());
    }

    public InteractiveSubmissionServiceOuterClass.GetPreferredPackagesRequest toProto() {
        InteractiveSubmissionServiceOuterClass.GetPreferredPackagesRequest.Builder builder = InteractiveSubmissionServiceOuterClass.GetPreferredPackagesRequest.newBuilder();
        this.packageVettingRequirements.forEach(packageVettingRequirements -> builder.addPackageVettingRequirements(packageVettingRequirements.toProto()));
        this.synchronizerId.ifPresent(builder::setSynchronizerId);
        this.vettingValidAt.ifPresent(instant -> builder.setVettingValidAt(Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build()));
        return builder.build();
    }

    public @NonNull List<@NonNull PackageVettingRequirement> getPackageVettingRequirements() {
        return this.packageVettingRequirements;
    }

    public @NonNull Optional<String> getSynchronizerId() {
        return this.synchronizerId;
    }

    public @NonNull Optional<Instant> getVettingValidAt() {
        return this.vettingValidAt;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPreferredPackagesRequest that = (GetPreferredPackagesRequest)o;
        return Objects.equals(this.packageVettingRequirements, that.packageVettingRequirements) && Objects.equals(this.synchronizerId, that.synchronizerId) && Objects.equals(this.vettingValidAt, that.vettingValidAt);
    }

    public int hashCode() {
        return Objects.hash(this.packageVettingRequirements, this.synchronizerId, this.vettingValidAt);
    }

    public String toString() {
        return "GetPreferredPackagesRequest{packageVettingRequirements=" + this.packageVettingRequirements + ", synchronizerId=" + this.synchronizerId + ", vettingValidAt=" + this.vettingValidAt + "}";
    }
}

