/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.admin.UserManagementServiceOuterClass;
import com.daml.ledger.javaapi.data.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class GrantUserRightsRequest {
    private final String userId;
    private final List<User.Right> rights;

    public GrantUserRightsRequest(String userId, User.Right right, User.Right ... rights) {
        this.userId = userId;
        this.rights = new ArrayList<User.Right>(rights.length + 1);
        this.rights.add(right);
        this.rights.addAll(Arrays.asList(rights));
    }

    public String getUserId() {
        return this.userId;
    }

    public List<User.Right> getRights() {
        return new ArrayList<User.Right>(this.rights);
    }

    public UserManagementServiceOuterClass.GrantUserRightsRequest toProto() {
        return UserManagementServiceOuterClass.GrantUserRightsRequest.newBuilder().setUserId(this.userId).addAllRights(this.rights.stream().map(User.Right::toProto).collect(Collectors.toList())).build();
    }

    public String toString() {
        return "GrantUserRightsRequest{userId=" + this.userId + ", rights=" + this.rights + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantUserRightsRequest that = (GrantUserRightsRequest)o;
        return this.userId.equals(that.userId) && this.rights.equals(that.rights);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.rights);
    }
}

