/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.PackageReferenceOuterClass;
import com.daml.ledger.javaapi.data.PackageVersion;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PackageReference {
    private final @NonNull String packageId;
    private final @NonNull String packageName;
    private final @NonNull PackageVersion packageVersion;

    public PackageReference(@NonNull String packageId, @NonNull String packageName, @NonNull PackageVersion packageVersion) {
        this.packageId = packageId;
        this.packageName = packageName;
        this.packageVersion = packageVersion;
    }

    public @NonNull String getPackageId() {
        return this.packageId;
    }

    public @NonNull String getPackageName() {
        return this.packageName;
    }

    public @NonNull PackageVersion getPackageVersion() {
        return this.packageVersion;
    }

    public static @NonNull PackageReference fromProto(@NonNull PackageReferenceOuterClass.PackageReference packageReference) {
        return new PackageReference(packageReference.getPackageId(), packageReference.getPackageName(), PackageVersion.unsafeFromString(packageReference.getPackageVersion()));
    }

    public @NonNull PackageReferenceOuterClass.PackageReference toProto() {
        return PackageReferenceOuterClass.PackageReference.newBuilder().setPackageId(this.packageId).setPackageName(this.packageName).setPackageVersion(this.packageVersion.toString()).build();
    }

    public String toString() {
        return "PackageReference{packageId='" + this.packageId + "', packageName='" + this.packageName + "', packageVersion=" + this.packageVersion + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageReference that = (PackageReference)o;
        return Objects.equals(this.packageId, that.packageId) && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.packageVersion, that.packageVersion);
    }

    public int hashCode() {
        return Objects.hash(this.packageId, this.packageName, this.packageVersion);
    }
}

