/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.TopologyTransactionOuterClass;
import com.daml.ledger.javaapi.data.ParticipantPermission;
import com.daml.ledger.javaapi.data.TopologyEvent;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ParticipantAuthorizationAdded
implements TopologyEvent {
    private final @NonNull String partyId;
    private final @NonNull String participantId;
    private final @NonNull ParticipantPermission permission;

    public ParticipantAuthorizationAdded(@NonNull String partyId, @NonNull String participantId, @NonNull ParticipantPermission permission) {
        this.partyId = partyId;
        this.participantId = participantId;
        this.permission = permission;
    }

    public @NonNull String getPartyId() {
        return this.partyId;
    }

    @Override
    public @NonNull String getParticipantId() {
        return this.participantId;
    }

    public @NonNull ParticipantPermission getPermission() {
        return this.permission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParticipantAuthorizationAdded that = (ParticipantAuthorizationAdded)o;
        return Objects.equals(this.partyId, that.partyId) && Objects.equals(this.participantId, that.participantId) && Objects.equals(this.permission, that.permission);
    }

    public int hashCode() {
        return Objects.hash(this.partyId, this.participantId, this.permission);
    }

    public String toString() {
        return "ParticipantAuthorizationAdded{partyId=" + this.partyId + ", participantId='" + this.participantId + ", permission=" + this.permission + "}";
    }

    public @NonNull TopologyTransactionOuterClass.ParticipantAuthorizationAdded toProto() {
        return TopologyTransactionOuterClass.ParticipantAuthorizationAdded.newBuilder().setPartyId(this.getPartyId()).setParticipantId(this.getParticipantId()).setParticipantPermission(this.getPermission().toProto()).build();
    }

    public static ParticipantAuthorizationAdded fromProto(TopologyTransactionOuterClass.ParticipantAuthorizationAdded addedEvent) {
        return new ParticipantAuthorizationAdded(addedEvent.getPartyId(), addedEvent.getParticipantId(), ParticipantPermission.fromProto(addedEvent.getParticipantPermission()));
    }
}

