/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.StateServiceOuterClass;
import com.daml.ledger.javaapi.data.ParticipantPermissionUnknown;
import com.daml.ledger.javaapi.data.ParticipantPermissionUnrecognized;

public abstract class ParticipantPermission {
    public static ParticipantPermission fromProto(StateServiceOuterClass.ParticipantPermission permission) {
        switch (permission.getNumber()) {
            case 1: {
                return Submission.instance;
            }
            case 2: {
                return Confirmation.instance;
            }
            case 3: {
                return Observation.instance;
            }
        }
        throw new ParticipantPermissionUnrecognized(permission);
    }

    public final StateServiceOuterClass.ParticipantPermission toProto() {
        if (this instanceof Submission) {
            return StateServiceOuterClass.ParticipantPermission.PARTICIPANT_PERMISSION_SUBMISSION;
        }
        if (this instanceof Confirmation) {
            return StateServiceOuterClass.ParticipantPermission.PARTICIPANT_PERMISSION_CONFIRMATION;
        }
        if (this instanceof Observation) {
            return StateServiceOuterClass.ParticipantPermission.PARTICIPANT_PERMISSION_OBSERVATION;
        }
        throw new ParticipantPermissionUnknown(this);
    }

    public static final class Submission
    extends ParticipantPermission {
        static Submission instance = new Submission();

        private Submission() {
        }

        public static Submission getInstance() {
            return instance;
        }

        public String toString() {
            return "ParticipantPermission.Submission";
        }
    }

    public static final class Confirmation
    extends ParticipantPermission {
        static Confirmation instance = new Confirmation();

        private Confirmation() {
        }

        public static Confirmation getInstance() {
            return instance;
        }

        public String toString() {
            return "ParticipantPermission.Confirmation";
        }
    }

    public static final class Observation
    extends ParticipantPermission {
        static Observation instance = new Observation();

        private Observation() {
        }

        public static Observation getInstance() {
            return instance;
        }

        public String toString() {
            return "ParticipantPermission.Observation";
        }
    }
}

