/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.ReassignmentOuterClass;
import com.daml.ledger.api.v2.TraceContextOuterClass;
import com.daml.ledger.javaapi.data.AssignedEvent;
import com.daml.ledger.javaapi.data.ReassignmentEvent;
import com.daml.ledger.javaapi.data.UnassignedEvent;
import com.daml.ledger.javaapi.data.Utils;
import com.daml.ledger.javaapi.data.WorkflowEvent;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Reassignment
implements WorkflowEvent {
    private final @NonNull String updateId;
    private final @NonNull String commandId;
    private final @NonNull String workflowId;
    private final @NonNull Long offset;
    private final @NonNull List<ReassignmentEvent> events;
    private final @NonNull TraceContextOuterClass.TraceContext traceContext;
    private final @NonNull Instant recordTime;

    private Reassignment(@NonNull String updateId, @NonNull String commandId, @NonNull String workflowId, @NonNull Long offset, @NonNull List<ReassignmentEvent> events, @NonNull TraceContextOuterClass.TraceContext traceContext, @NonNull Instant recordTime) {
        this.updateId = updateId;
        this.commandId = commandId;
        this.workflowId = workflowId;
        this.offset = offset;
        this.events = events;
        this.traceContext = traceContext;
        this.recordTime = recordTime;
    }

    public Reassignment(@NonNull String updateId, @NonNull String commandId, @NonNull String workflowId, @NonNull Long offset, @NonNull UnassignedEvent unassignedEvent, @NonNull TraceContextOuterClass.TraceContext traceContext, @NonNull Instant recordTime) {
        this(updateId, commandId, workflowId, offset, Arrays.asList(unassignedEvent), traceContext, recordTime);
    }

    public Reassignment(@NonNull String updateId, @NonNull String commandId, @NonNull String workflowId, @NonNull Long offset, @NonNull AssignedEvent assignedEvent, @NonNull TraceContextOuterClass.TraceContext traceContext, @NonNull Instant recordTime) {
        this(updateId, commandId, workflowId, offset, Arrays.asList(assignedEvent), traceContext, recordTime);
    }

    public @NonNull String getUpdateId() {
        return this.updateId;
    }

    public @NonNull String getCommandId() {
        return this.commandId;
    }

    @Override
    public @NonNull String getWorkflowId() {
        return this.workflowId;
    }

    public @NonNull Long getOffset() {
        return this.offset;
    }

    public @NonNull List<ReassignmentEvent> getEvents() {
        return this.events;
    }

    public @NonNull TraceContextOuterClass.TraceContext getTraceContext() {
        return this.traceContext;
    }

    public @NonNull Instant getRecordTime() {
        return this.recordTime;
    }

    public static Reassignment fromProto(ReassignmentOuterClass.Reassignment reassignment) {
        List<ReassignmentEvent> events = reassignment.getEventsList().stream().map(ReassignmentEvent::fromProtoEvent).collect(Collectors.toList());
        return new Reassignment(reassignment.getUpdateId(), reassignment.getCommandId(), reassignment.getWorkflowId(), (Long)reassignment.getOffset(), events, reassignment.getTraceContext(), Utils.instantFromProto(reassignment.getRecordTime()));
    }

    public ReassignmentOuterClass.Reassignment toProto() {
        return ReassignmentOuterClass.Reassignment.newBuilder().setUpdateId(this.updateId).setCommandId(this.commandId).setWorkflowId(this.workflowId).setOffset(this.offset).addAllEvents(this.events.stream().map(ReassignmentEvent::toProtoEvent).collect(Collectors.toList())).setTraceContext(this.traceContext).setRecordTime(Utils.instantToProto(this.recordTime)).build();
    }

    public String toString() {
        return "Reassignment{updateId='" + this.updateId + "', commandId='" + this.commandId + "', workflowId='" + this.workflowId + "', offset='" + this.offset + "', events=" + this.events + ", traceContext=" + this.traceContext + ", recordTime=" + this.recordTime + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reassignment that = (Reassignment)o;
        return Objects.equals(this.updateId, that.updateId) && Objects.equals(this.commandId, that.commandId) && Objects.equals(this.workflowId, that.workflowId) && Objects.equals(this.offset, that.offset) && Objects.equals(this.events, that.events) && Objects.equals(this.traceContext, that.traceContext) && Objects.equals(this.recordTime, that.recordTime);
    }

    public int hashCode() {
        return Objects.hash(this.updateId, this.commandId, this.workflowId, this.offset, this.events, this.traceContext, this.recordTime);
    }
}

