/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.ReassignmentCommandOuterClass;
import com.daml.ledger.javaapi.data.AssignCommand;
import com.daml.ledger.javaapi.data.ReassignmentCommand;
import com.daml.ledger.javaapi.data.UnassignCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ReassignmentCommands {
    private final @NonNull Optional<String> workflowId;
    private final @NonNull String userId;
    private final @NonNull String commandId;
    private final @NonNull String submitter;
    private final @NonNull List<ReassignmentCommand> commands;
    private final @NonNull Optional<String> submissionId;

    protected ReassignmentCommands(@NonNull Optional<String> workflowId, @NonNull String userId, @NonNull String commandId, @NonNull String submitter, @NonNull List<ReassignmentCommand> commands, @NonNull Optional<String> submissionId) {
        this.workflowId = workflowId;
        this.userId = userId;
        this.commandId = commandId;
        this.submitter = submitter;
        this.commands = commands;
        this.submissionId = submissionId;
    }

    public static ReassignmentCommands create(@NonNull String userId, @NonNull String commandId, @NonNull String submitter, @NonNull UnassignCommand unassignCommand) {
        return new ReassignmentCommands(Optional.empty(), userId, commandId, submitter, Arrays.asList(unassignCommand), Optional.empty());
    }

    public static ReassignmentCommands create(@NonNull String userId, @NonNull String commandId, @NonNull String submitter, @NonNull AssignCommand assignCommand) {
        return new ReassignmentCommands(Optional.empty(), userId, commandId, submitter, Arrays.asList(assignCommand), Optional.empty());
    }

    public ReassignmentCommands withWorkflowId(@NonNull String workflowId) {
        return new ReassignmentCommands(Optional.of(workflowId), this.userId, this.commandId, this.submitter, this.commands, this.submissionId);
    }

    public ReassignmentCommands withSubmissionId(@NonNull String submissionId) {
        return new ReassignmentCommands(this.workflowId, this.userId, this.commandId, this.submitter, this.commands, Optional.of(submissionId));
    }

    public @NonNull Optional<String> getWorkflowId() {
        return this.workflowId;
    }

    public @NonNull String getUserId() {
        return this.userId;
    }

    public @NonNull String getCommandId() {
        return this.commandId;
    }

    public @NonNull String getSubmitter() {
        return this.submitter;
    }

    public @NonNull List<ReassignmentCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public @NonNull Optional<String> getSubmissionId() {
        return this.submissionId;
    }

    public ReassignmentCommandOuterClass.ReassignmentCommands toProto() {
        List commandsConverted = this.commands.stream().map(ReassignmentCommand::toProtoCommand).collect(Collectors.toList());
        ReassignmentCommandOuterClass.ReassignmentCommands.Builder builder = ReassignmentCommandOuterClass.ReassignmentCommands.newBuilder().setUserId(this.userId).setCommandId(this.commandId).setSubmitter(this.submitter).addAllCommands(commandsConverted);
        this.workflowId.ifPresent(builder::setWorkflowId);
        this.submissionId.ifPresent(builder::setSubmissionId);
        return builder.build();
    }

    public static ReassignmentCommands fromProto(ReassignmentCommandOuterClass.ReassignmentCommands commands) {
        Optional<String> workflowId = commands.getWorkflowId().isEmpty() ? Optional.empty() : Optional.of(commands.getWorkflowId());
        Optional<String> submissionId = commands.getSubmissionId().isEmpty() ? Optional.empty() : Optional.of(commands.getSubmissionId());
        List<ReassignmentCommand> convertedCommands = commands.getCommandsList().stream().map(ReassignmentCommand::fromProtoCommand).collect(Collectors.toList());
        return new ReassignmentCommands(workflowId, commands.getUserId(), commands.getCommandId(), commands.getSubmitter(), convertedCommands, submissionId);
    }

    public String toString() {
        return "ReassignmentCommands{workflowId='" + this.workflowId + "', userId='" + this.userId + "', commandId='" + this.commandId + "', submitter=" + this.submitter + ", commands=" + this.commands + ", submissionId='" + this.submissionId + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReassignmentCommands commandsSubmission = (ReassignmentCommands)o;
        return Objects.equals(this.workflowId, commandsSubmission.workflowId) && Objects.equals(this.userId, commandsSubmission.userId) && Objects.equals(this.commandId, commandsSubmission.commandId) && Objects.equals(this.submitter, commandsSubmission.submitter) && Objects.equals(this.commands, commandsSubmission.commands) && Objects.equals(this.submissionId, commandsSubmission.submissionId);
    }

    public int hashCode() {
        return Objects.hash(this.workflowId, this.userId, this.commandId, this.submitter, this.commands, this.submissionId);
    }
}

