/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.CommandServiceOuterClass;
import com.daml.ledger.javaapi.data.EventFormat;
import com.daml.ledger.javaapi.data.ReassignmentCommands;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SubmitAndWaitForReassignmentRequest {
    private final @NonNull ReassignmentCommands reassignmentCommands;
    private final @NonNull Optional<EventFormat> eventFormat;

    public SubmitAndWaitForReassignmentRequest(@NonNull ReassignmentCommands reassignmentCommands, @NonNull Optional<EventFormat> eventFormat) {
        this.reassignmentCommands = reassignmentCommands;
        this.eventFormat = eventFormat;
    }

    public @NonNull ReassignmentCommands getReassignmentCommands() {
        return this.reassignmentCommands;
    }

    public @NonNull Optional<EventFormat> getEventFormat() {
        return this.eventFormat;
    }

    public CommandServiceOuterClass.SubmitAndWaitForReassignmentRequest toProto() {
        CommandServiceOuterClass.SubmitAndWaitForReassignmentRequest.Builder builder = CommandServiceOuterClass.SubmitAndWaitForReassignmentRequest.newBuilder().setReassignmentCommands(this.reassignmentCommands.toProto());
        this.eventFormat.ifPresent(eventFormat -> builder.setEventFormat(eventFormat.toProto()));
        return builder.build();
    }

    public static SubmitAndWaitForReassignmentRequest fromProto(CommandServiceOuterClass.SubmitAndWaitForReassignmentRequest request) {
        Optional<EventFormat> eventFormat = request.hasEventFormat() ? Optional.of(EventFormat.fromProto(request.getEventFormat())) : Optional.empty();
        return new SubmitAndWaitForReassignmentRequest(ReassignmentCommands.fromProto(request.getReassignmentCommands()), eventFormat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmitAndWaitForReassignmentRequest that = (SubmitAndWaitForReassignmentRequest)o;
        return Objects.equals(this.reassignmentCommands, that.reassignmentCommands) && Objects.equals(this.eventFormat, that.eventFormat);
    }

    public String toString() {
        return "SubmitAndWaitForReassignmentRequest{reassignmentCommands=" + this.reassignmentCommands + ", eventFormat=" + this.eventFormat + "}";
    }

    public int hashCode() {
        return Objects.hash(this.reassignmentCommands, this.eventFormat);
    }
}

