/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.CommandServiceOuterClass;
import com.daml.ledger.javaapi.data.CommandsSubmission;
import com.daml.ledger.javaapi.data.CumulativeFilter;
import com.daml.ledger.javaapi.data.EventFormat;
import com.daml.ledger.javaapi.data.Filter;
import com.daml.ledger.javaapi.data.TransactionFormat;
import com.daml.ledger.javaapi.data.TransactionShape;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SubmitAndWaitForTransactionRequest {
    private final @NonNull CommandsSubmission submission;
    private final @NonNull TransactionFormat transactionFormat;

    public SubmitAndWaitForTransactionRequest(@NonNull CommandsSubmission submission, @NonNull TransactionFormat transactionFormat) {
        this.submission = submission;
        this.transactionFormat = transactionFormat;
    }

    public SubmitAndWaitForTransactionRequest(@NonNull CommandsSubmission submission) {
        Map<String, Filter> partyFilters = submission.getActAs().stream().collect(Collectors.toMap(party -> party, party -> new CumulativeFilter(Map.of(), Map.of(), Optional.of(Filter.Wildcard.HIDE_CREATED_EVENT_BLOB))));
        EventFormat eventFormat = new EventFormat(partyFilters, Optional.empty(), true);
        TransactionFormat transactionFormat = new TransactionFormat(eventFormat, TransactionShape.ACS_DELTA);
        this.submission = submission;
        this.transactionFormat = transactionFormat;
    }

    public @NonNull CommandsSubmission getCommandsSubmission() {
        return this.submission;
    }

    public @NonNull TransactionFormat getTransactionFormat() {
        return this.transactionFormat;
    }

    public CommandServiceOuterClass.SubmitAndWaitForTransactionRequest toProto() {
        return CommandServiceOuterClass.SubmitAndWaitForTransactionRequest.newBuilder().setCommands(this.submission.toProto()).setTransactionFormat(this.transactionFormat.toProto()).build();
    }

    public static SubmitAndWaitForTransactionRequest fromProto(CommandServiceOuterClass.SubmitAndWaitForTransactionRequest request) {
        return new SubmitAndWaitForTransactionRequest(CommandsSubmission.fromProto(request.getCommands()), TransactionFormat.fromProto(request.getTransactionFormat()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmitAndWaitForTransactionRequest that = (SubmitAndWaitForTransactionRequest)o;
        return Objects.equals(this.submission, that.submission) && Objects.equals(this.transactionFormat, that.transactionFormat);
    }

    public String toString() {
        return "SubmitAndWaitForTransactionRequest{submission=" + this.submission + ", transactionFormat=" + this.transactionFormat + "}";
    }

    public int hashCode() {
        return Objects.hash(this.submission, this.transactionFormat);
    }
}

