/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.TraceContextOuterClass;
import com.daml.ledger.api.v2.TransactionOuterClass;
import com.daml.ledger.javaapi.data.Event;
import com.daml.ledger.javaapi.data.ExercisedEvent;
import com.daml.ledger.javaapi.data.Utils;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Transaction {
    private final @NonNull String updateId;
    private final @NonNull String commandId;
    private final @NonNull String workflowId;
    private final @NonNull Instant effectiveAt;
    private final @NonNull List<@NonNull Event> events;
    private final @NonNull Long offset;
    private final @NonNull String synchronizerId;
    private final @NonNull TraceContextOuterClass.TraceContext traceContext;
    private final @NonNull Instant recordTime;
    private final @NonNull Map<Integer, @NonNull Node> nodesById;
    private final @NonNull List<@NonNull Node> rootNodes;
    private final @NonNull List<@NonNull Integer> rootNodeIds;

    private static List<Node> buildNodeForest(LinkedList<Node> nodes) {
        ArrayList<Node> rootNodes = new ArrayList<Node>();
        while (!nodes.isEmpty()) {
            Node root = nodes.pollFirst();
            rootNodes.add(root);
            Transaction.buildNodeTree(root, nodes);
        }
        return Collections.unmodifiableList(rootNodes);
    }

    private static void buildNodeTree(Node parent, LinkedList<Node> nodes) {
        while (!nodes.isEmpty() && nodes.peekFirst().nodeId <= parent.lastDescendantNodeId) {
            parent.children.add(nodes.peekFirst());
            Transaction.buildNodeTree(nodes.pollFirst(), nodes);
        }
    }

    public Transaction(@NonNull String updateId, @NonNull String commandId, @NonNull String workflowId, @NonNull Instant effectiveAt, @NonNull List<@NonNull Event> events, @NonNull Long offset, @NonNull String synchronizerId, @NonNull TraceContextOuterClass.TraceContext traceContext, @NonNull Instant recordTime) {
        for (int i = 1; i < events.size(); ++i) {
            if (events.get(i - 1).getNodeId() <= events.get(i).getNodeId()) continue;
            throw new IllegalArgumentException("Events are not sorted by nodeId at index " + i);
        }
        this.updateId = updateId;
        this.commandId = commandId;
        this.workflowId = workflowId;
        this.effectiveAt = effectiveAt;
        this.events = events;
        this.offset = offset;
        this.synchronizerId = synchronizerId;
        this.traceContext = traceContext;
        this.recordTime = recordTime;
        LinkedList nodes = this.getEvents().stream().map(event -> new Node(event.getNodeId(), event.toProtoEvent().hasExercised() ? event.toProtoEvent().getExercised().getLastDescendantNodeId() : event.getNodeId().intValue())).collect(Collectors.toCollection(LinkedList::new));
        this.nodesById = nodes.stream().collect(Collectors.toUnmodifiableMap(node -> node.nodeId, node -> node));
        this.rootNodes = Transaction.buildNodeForest(nodes);
        this.rootNodeIds = this.rootNodes.stream().map(node -> node.nodeId).toList();
    }

    public @NonNull String getUpdateId() {
        return this.updateId;
    }

    public @NonNull String getCommandId() {
        return this.commandId;
    }

    public @NonNull String getWorkflowId() {
        return this.workflowId;
    }

    public @NonNull Instant getEffectiveAt() {
        return this.effectiveAt;
    }

    public @NonNull List<Event> getEvents() {
        return this.events;
    }

    public @NonNull Long getOffset() {
        return this.offset;
    }

    public @NonNull String getSynchronizerId() {
        return this.synchronizerId;
    }

    public @NonNull TraceContextOuterClass.TraceContext getTraceContext() {
        return this.traceContext;
    }

    public @NonNull Instant getRecordTime() {
        return this.recordTime;
    }

    public @NonNull Map<Integer, Event> getEventsById() {
        return this.getEvents().stream().collect(Collectors.toMap(Event::getNodeId, event -> event));
    }

    public @NonNull List<Integer> getRootNodeIds() {
        return this.rootNodeIds;
    }

    public List<@NonNull Integer> getChildNodeIds(ExercisedEvent exercised) {
        Integer nodeId = exercised.getNodeId();
        Node parentNode = this.nodesById.get(nodeId);
        if (parentNode == null) {
            throw new RuntimeException("Node with id " + nodeId + " not found.");
        }
        return parentNode.children.stream().map(child -> child.nodeId).collect(Collectors.toList());
    }

    public @NonNull List<@NonNull Node> getRootNodes() {
        return this.rootNodes;
    }

    public <WrappedEvent> WrappedTransactionTree<WrappedEvent> toWrappedTree(BiFunction<Event, List<WrappedEvent>, WrappedEvent> createWrappedEvent) {
        List<Object> wrappedRootEvents = this.getRootNodes().stream().map(rootNode -> Transaction.buildWrappedEventTree(rootNode, this.getEventsById(), createWrappedEvent)).toList();
        return new WrappedTransactionTree<Object>(this, wrappedRootEvents);
    }

    private static <WrappedEvent> WrappedEvent buildWrappedEventTree(Node root, Map<Integer, Event> eventsById, BiFunction<Event, List<WrappedEvent>, WrappedEvent> createWrappedEvent) {
        Integer nodeId = root.getNodeId();
        Event event = eventsById.get(nodeId);
        if (event == null) {
            throw new RuntimeException("Event with id " + nodeId + " not found");
        }
        List childrenWrapped = root.getChildren().stream().map(child -> Transaction.buildWrappedEventTree(child, eventsById, createWrappedEvent)).collect(Collectors.toList());
        return createWrappedEvent.apply(event, childrenWrapped);
    }

    public static Transaction fromProto(TransactionOuterClass.Transaction transaction) {
        Instant effectiveAt = Instant.ofEpochSecond(transaction.getEffectiveAt().getSeconds(), transaction.getEffectiveAt().getNanos());
        List<Event> events = transaction.getEventsList().stream().map(Event::fromProtoEvent).collect(Collectors.toList());
        return new Transaction(transaction.getUpdateId(), transaction.getCommandId(), transaction.getWorkflowId(), effectiveAt, events, transaction.getOffset(), transaction.getSynchronizerId(), transaction.getTraceContext(), Utils.instantFromProto(transaction.getRecordTime()));
    }

    public TransactionOuterClass.Transaction toProto() {
        return TransactionOuterClass.Transaction.newBuilder().setUpdateId(this.updateId).setCommandId(this.commandId).setWorkflowId(this.workflowId).setEffectiveAt(Timestamp.newBuilder().setSeconds(this.effectiveAt.getEpochSecond()).setNanos(this.effectiveAt.getNano()).build()).addAllEvents(this.events.stream().map(Event::toProtoEvent).collect(Collectors.toList())).setOffset(this.offset).setSynchronizerId(this.synchronizerId).setTraceContext(this.traceContext).setRecordTime(Utils.instantToProto(this.recordTime)).build();
    }

    public String toString() {
        return "Transaction{updateId='" + this.updateId + "', commandId='" + this.commandId + "', workflowId='" + this.workflowId + "', effectiveAt=" + this.effectiveAt + ", events=" + this.events + ", offset='" + this.offset + "', synchronizerId='" + this.synchronizerId + "', traceContext=" + this.traceContext + ", recordTime=" + this.recordTime + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return Objects.equals(this.updateId, that.updateId) && Objects.equals(this.commandId, that.commandId) && Objects.equals(this.workflowId, that.workflowId) && Objects.equals(this.effectiveAt, that.effectiveAt) && Objects.equals(this.events, that.events) && Objects.equals(this.offset, that.offset) && Objects.equals(this.synchronizerId, that.synchronizerId) && Objects.equals(this.traceContext, that.traceContext) && Objects.equals(this.recordTime, that.recordTime);
    }

    public int hashCode() {
        return Objects.hash(this.updateId, this.commandId, this.workflowId, this.effectiveAt, this.events, this.offset, this.synchronizerId, this.traceContext, this.recordTime);
    }

    public static class Node {
        private final Integer nodeId;
        private final Integer lastDescendantNodeId;
        private final List<Node> children;

        public Node(Integer nodeId, Integer lastDescendant) {
            this.nodeId = nodeId;
            this.lastDescendantNodeId = lastDescendant;
            this.children = new ArrayList<Node>();
        }

        public Integer getNodeId() {
            return this.nodeId;
        }

        public Integer getLastDescendantNodeId() {
            return this.lastDescendantNodeId;
        }

        public List<Node> getChildren() {
            return Collections.unmodifiableList(this.children);
        }
    }

    public static class WrappedTransactionTree<WrappedEvent> {
        private final Transaction transaction;
        private final List<WrappedEvent> wrappedRootEvents;

        public WrappedTransactionTree(Transaction transaction, List<WrappedEvent> wrappedRootEvents) {
            this.transaction = transaction;
            this.wrappedRootEvents = wrappedRootEvents;
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public List<WrappedEvent> getWrappedRootEvents() {
            return this.wrappedRootEvents;
        }
    }
}

