/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.TransactionFilterOuterClass;
import com.daml.ledger.javaapi.data.EventFormat;
import com.daml.ledger.javaapi.data.TransactionShape;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TransactionFormat {
    private final EventFormat eventFormat;
    private final TransactionShape transactionShape;

    public static TransactionFormat fromProto(TransactionFilterOuterClass.TransactionFormat transactionFormat) {
        return new TransactionFormat(EventFormat.fromProto(transactionFormat.getEventFormat()), TransactionShape.fromProto(transactionFormat.getTransactionShape()));
    }

    public TransactionFilterOuterClass.TransactionFormat toProto() {
        return TransactionFilterOuterClass.TransactionFormat.newBuilder().setEventFormat(this.eventFormat.toProto()).setTransactionShape(this.transactionShape.toProto()).build();
    }

    public EventFormat getEventFormat() {
        return this.eventFormat;
    }

    public TransactionShape getTransactionShape() {
        return this.transactionShape;
    }

    public TransactionFormat(@NonNull EventFormat eventFormat, @NonNull TransactionShape transactionShape) {
        this.eventFormat = eventFormat;
        this.transactionShape = transactionShape;
    }

    public String toString() {
        return "TransactionFormat{eventFormat=" + this.eventFormat + ", transactionShape=" + this.transactionShape + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionFormat that = (TransactionFormat)o;
        return Objects.equals(this.eventFormat, that.eventFormat) && Objects.equals((Object)this.transactionShape, (Object)that.transactionShape);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventFormat, this.transactionShape});
    }
}

