/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.javaapi.data.CommandsSubmission;
import com.daml.ledger.javaapi.data.DisclosedContract;
import com.daml.ledger.javaapi.data.PrefetchContractKey;
import com.daml.ledger.javaapi.data.codegen.Update;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class UpdateSubmission<U> {
    private final @NonNull String userId;
    private final @NonNull String commandId;
    private final @NonNull Update<U> update;
    private final @NonNull Optional<String> workflowId;
    private final @NonNull List<@NonNull String> actAs;
    private final @NonNull List<@NonNull String> readAs;
    private final @NonNull Optional<Instant> minLedgerTimeAbs;
    private final @NonNull Optional<Duration> minLedgerTimeRel;
    private final @NonNull Optional<Duration> deduplicationDuration;
    private final @NonNull Optional<Long> deduplicationOffset;
    private final @NonNull Optional<String> accessToken;
    private final @NonNull List<DisclosedContract> disclosedContracts;
    private final @NonNull List<@NonNull String> packageIdSelectionPreference;
    private @NonNull List<@NonNull PrefetchContractKey> prefetchContractKeys;
    private final @NonNull Optional<String> synchronizerId;

    private UpdateSubmission(@NonNull String userId, @NonNull String commandId, @NonNull Update<U> update, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<String> workflowId, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationDuration, @NonNull Optional<Long> deduplicationOffset, @NonNull Optional<String> accessToken, @NonNull Optional<String> synchronizerId, @NonNull List<DisclosedContract> disclosedContracts, @NonNull List<@NonNull String> packageIdSelectionPreference, @NonNull List<@NonNull PrefetchContractKey> prefetchContractKeys) {
        this.workflowId = workflowId;
        this.userId = userId;
        this.commandId = commandId;
        this.actAs = actAs;
        this.readAs = readAs;
        this.minLedgerTimeAbs = minLedgerTimeAbs;
        this.minLedgerTimeRel = minLedgerTimeRel;
        this.deduplicationDuration = deduplicationDuration;
        this.deduplicationOffset = deduplicationOffset;
        this.update = update;
        this.accessToken = accessToken;
        this.synchronizerId = synchronizerId;
        this.disclosedContracts = disclosedContracts;
        this.packageIdSelectionPreference = packageIdSelectionPreference;
        this.prefetchContractKeys = prefetchContractKeys;
    }

    public static <U> UpdateSubmission<U> create(String userId, String commandId, Update<U> update) {
        return new UpdateSubmission<U>(userId, commandId, update, Collections.emptyList(), Collections.emptyList(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public Optional<String> getWorkflowId() {
        return this.workflowId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public List<String> getActAs() {
        return Collections.unmodifiableList(this.actAs);
    }

    public List<String> getReadAs() {
        return Collections.unmodifiableList(this.readAs);
    }

    public Optional<Instant> getMinLedgerTimeAbs() {
        return this.minLedgerTimeAbs;
    }

    public Optional<Duration> getMinLedgerTimeRel() {
        return this.minLedgerTimeRel;
    }

    public Optional<Duration> getDeduplicationDuration() {
        return this.deduplicationDuration;
    }

    public Optional<Long> getDeduplicationOffset() {
        return this.deduplicationOffset;
    }

    public Update<U> getUpdate() {
        return this.update;
    }

    public Optional<String> getAccessToken() {
        return this.accessToken;
    }

    public Optional<String> getSynchronizerId() {
        return this.synchronizerId;
    }

    public @NonNull List<DisclosedContract> getDisclosedContracts() {
        return Collections.unmodifiableList(this.disclosedContracts);
    }

    public List<String> getPackageIdSelectionPreference() {
        return Collections.unmodifiableList(this.packageIdSelectionPreference);
    }

    public List<PrefetchContractKey> getPrefetchContractKeys() {
        return Collections.unmodifiableList(this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withWorkflowId(String workflowId) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, this.actAs, this.readAs, Optional.of(workflowId), this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationDuration, this.deduplicationOffset, this.accessToken, this.synchronizerId, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withActAs(String actAs) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, List.of(actAs), this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationDuration, this.deduplicationOffset, this.accessToken, this.synchronizerId, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withActAs(List<@NonNull String> actAs) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationDuration, this.deduplicationOffset, this.accessToken, this.synchronizerId, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withReadAs(List<@NonNull String> readAs) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, this.actAs, readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationDuration, this.deduplicationOffset, this.accessToken, this.synchronizerId, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withMinLedgerTimeAbs(Optional<Instant> minLedgerTimeAbs) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationDuration, this.deduplicationOffset, this.accessToken, this.synchronizerId, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withMinLedgerTimeRel(Optional<Duration> minLedgerTimeRel) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, minLedgerTimeRel, this.deduplicationDuration, this.deduplicationOffset, this.accessToken, this.synchronizerId, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withDeduplicationDuration(Optional<Duration> deduplicationDuration) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, deduplicationDuration, this.deduplicationOffset, this.accessToken, this.synchronizerId, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withDeduplicationOffset(Optional<Long> deduplicationOffset) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationDuration, deduplicationOffset, this.accessToken, this.synchronizerId, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withAccessToken(Optional<String> accessToken) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationDuration, this.deduplicationOffset, accessToken, this.synchronizerId, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withSynchronizerId(String synchronizerId) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationDuration, this.deduplicationOffset, this.accessToken, this.synchronizerId, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withDisclosedContracts(List<@NonNull DisclosedContract> disclosedContracts) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationDuration, this.deduplicationOffset, this.accessToken, this.synchronizerId, disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withPackageIdSelectionPreference(List<@NonNull String> packageIdSelectionPreference) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationDuration, this.deduplicationOffset, this.accessToken, this.synchronizerId, this.disclosedContracts, packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withPrefetchContractKeys(List<PrefetchContractKey> prefetchContractKeys) {
        return new UpdateSubmission<U>(this.userId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationDuration, this.deduplicationOffset, this.accessToken, this.synchronizerId, this.disclosedContracts, this.packageIdSelectionPreference, prefetchContractKeys);
    }

    public CommandsSubmission toCommandsSubmission() {
        return new CommandsSubmission(this.workflowId, this.userId, this.commandId, this.update.commands(), this.deduplicationDuration, this.deduplicationOffset, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.actAs, this.readAs, Optional.empty(), this.disclosedContracts, this.synchronizerId, this.accessToken, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }
}

