/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.ValueOuterClass;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Value;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Variant
extends Value {
    private final Optional<Identifier> variantId;
    private final String constructor;
    private final Value value;

    public Variant(@NonNull Identifier variantId, @NonNull String constructor, @NonNull Value value) {
        this.variantId = Optional.of(variantId);
        this.constructor = constructor;
        this.value = value;
    }

    public Variant(@NonNull String constructor, @NonNull Value value) {
        this.variantId = Optional.empty();
        this.constructor = constructor;
        this.value = value;
    }

    public static Variant fromProto(ValueOuterClass.Variant variant) {
        String constructor = variant.getConstructor();
        Value value = Value.fromProto(variant.getValue());
        if (variant.hasVariantId()) {
            Identifier variantId = Identifier.fromProto(variant.getVariantId());
            return new Variant(variantId, constructor, value);
        }
        return new Variant(constructor, value);
    }

    public @NonNull Optional<Identifier> getVariantId() {
        return this.variantId;
    }

    public @NonNull String getConstructor() {
        return this.constructor;
    }

    public @NonNull Value getValue() {
        return this.value;
    }

    @Override
    public ValueOuterClass.Value toProto() {
        return ValueOuterClass.Value.newBuilder().setVariant(this.toProtoVariant()).build();
    }

    public ValueOuterClass.Variant toProtoVariant() {
        ValueOuterClass.Variant.Builder builder = ValueOuterClass.Variant.newBuilder();
        builder.setConstructor(this.getConstructor());
        this.getVariantId().ifPresent(identifier -> builder.setVariantId(identifier.toProto()));
        builder.setValue(this.value.toProto());
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variant variant = (Variant)o;
        return Objects.equals(this.variantId, variant.variantId) && Objects.equals(this.constructor, variant.constructor) && Objects.equals(this.value, variant.value);
    }

    public int hashCode() {
        return Objects.hash(this.variantId, this.constructor, this.value);
    }

    public String toString() {
        return "Variant{variantId=" + this.variantId + ", constructor='" + this.constructor + "', value=" + this.value + "}";
    }
}

