/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen;

import com.daml.ledger.javaapi.data.Contract;
import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.codegen.ContractCompanion;
import com.daml.ledger.javaapi.data.codegen.DamlRecord;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ContractDecoder {
    private final Map<Identifier, ? extends ContractCompanion<? extends com.daml.ledger.javaapi.data.codegen.Contract<?, ?>, ?, ? extends DamlRecord<?>>> companions;

    public ContractDecoder(Iterable<? extends ContractCompanion<? extends com.daml.ledger.javaapi.data.codegen.Contract<?, ?>, ?, ? extends DamlRecord<?>>> companions) {
        this.companions = StreamSupport.stream(companions.spliterator(), false).flatMap(c -> Stream.of(Map.entry(c.TEMPLATE_ID, c), Map.entry(c.getTemplateIdWithPackageId(), c))).collect(Collectors.toMap(e -> (Identifier)e.getKey(), e -> (ContractCompanion)e.getValue(), (v1, v2) -> {
            throw new IllegalArgumentException("Clashing templates with the same key " + v1.TEMPLATE_ID + " and " + v2.TEMPLATE_ID);
        }));
    }

    public com.daml.ledger.javaapi.data.codegen.Contract<?, ?> fromCreatedEvent(CreatedEvent event) throws IllegalArgumentException {
        Identifier templateId = event.getTemplateId();
        Optional<ContractCompanion<com.daml.ledger.javaapi.data.codegen.Contract<?, ?>, ?, DamlRecord<?>>> companion = this.getContractCompanion(templateId);
        if (!companion.isPresent()) {
            companion = this.getContractCompanion(this.withPackageName(templateId, event.getPackageName()));
        }
        if (!companion.isPresent()) {
            throw new IllegalArgumentException("No template found for identifier " + templateId);
        }
        return (com.daml.ledger.javaapi.data.codegen.Contract)companion.get().fromCreatedEvent(event);
    }

    public Optional<? extends ContractCompanion<? extends com.daml.ledger.javaapi.data.codegen.Contract<?, ?>, ?, ? extends DamlRecord<?>>> getContractCompanion(Identifier templateId) {
        return Optional.ofNullable(this.companions.get(templateId));
    }

    public Optional<Function<CreatedEvent, Contract>> getDecoder(Identifier templateId) {
        return this.getContractCompanion(templateId).map(companion -> companion::fromCreatedEvent);
    }

    public Optional<ContractCompanion.FromJson<? extends DamlRecord<?>>> getJsonDecoder(Identifier templateId) {
        return this.getContractCompanion(templateId).map(companion -> companion::fromJson);
    }

    private Identifier withPackageName(Identifier templateId, String pkgName) {
        return new Identifier("#" + pkgName, templateId.getModuleName(), templateId.getEntityName());
    }
}

