/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen;

import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.DamlRecord;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.javaapi.data.codegen.Choice;
import com.daml.ledger.javaapi.data.codegen.Contract;
import com.daml.ledger.javaapi.data.codegen.ContractTypeCompanion;
import com.daml.ledger.javaapi.data.codegen.ContractWithInterfaceView;
import com.daml.ledger.javaapi.data.codegen.ValueDecoder;
import com.daml.ledger.javaapi.data.codegen.json.JsonLfDecoder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public abstract class InterfaceCompanion<I, Id, View>
extends ContractTypeCompanion<Contract<Id, View>, Id, I, View> {
    public final ValueDecoder<View> valueDecoder;
    private final FromJson<View> fromJson;

    protected InterfaceCompanion(ContractTypeCompanion.Package packageInfo, String templateClassName, Identifier templateId, Function<String, Id> newContractId, ValueDecoder<View> valueDecoder, FromJson<View> fromJson, List<Choice<I, ?, ?>> choices) {
        super(packageInfo, templateId, templateClassName, newContractId, choices);
        this.valueDecoder = valueDecoder;
        this.fromJson = fromJson;
    }

    public View fromJson(String json) throws JsonLfDecoder.Error {
        return this.fromJson.decode(json);
    }

    private Contract<Id, View> fromIdAndRecord(String contractId, Map<Identifier, DamlRecord> interfaceViews, Set<String> signatories, Set<String> observers) throws IllegalArgumentException {
        Optional<DamlRecord> maybeRecord = Optional.ofNullable(interfaceViews.get(this.TEMPLATE_ID_WITH_PACKAGE_ID));
        Object id = this.newContractId.apply(contractId);
        return maybeRecord.map(record -> {
            View view = this.valueDecoder.decode((Value)record);
            return new ContractWithInterfaceView<Object, View>(this, id, view, signatories, observers);
        }).orElseThrow(() -> new IllegalArgumentException("interface view of " + this.TEMPLATE_ID_WITH_PACKAGE_ID + " not found."));
    }

    @Override
    public final Contract<Id, View> fromCreatedEvent(CreatedEvent event) throws IllegalArgumentException {
        return this.fromIdAndRecord(event.getContractId(), event.getInterfaceViews(), event.getSignatories(), event.getObservers());
    }

    @FunctionalInterface
    public static interface FromJson<T> {
        public T decode(String var1) throws JsonLfDecoder.Error;
    }
}

