/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen.json;

import com.daml.ledger.javaapi.data.Unit;
import com.daml.ledger.javaapi.data.codegen.ContractId;
import com.daml.ledger.javaapi.data.codegen.json.JsonLfDecoder;
import com.daml.ledger.javaapi.data.codegen.json.JsonLfReader;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class JsonLfDecoders {
    public static final JsonLfDecoder<Unit> unit = r -> {
        r.readStartObject();
        r.readEndObject();
        return Unit.getInstance();
    };
    public static final JsonLfDecoder<Boolean> bool = r -> {
        r.expectIsAt("boolean", JsonToken.VALUE_TRUE, JsonToken.VALUE_FALSE);
        Boolean value = null;
        try {
            value = Boolean.parseBoolean(r.currentText("boolean"));
        }
        catch (IOException e) {
            r.parseExpected("true or false", e);
        }
        r.moveNext();
        return value;
    };
    public static final JsonLfDecoder<Long> int64 = r -> {
        r.expectIsAt("int64", JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING);
        Long value = null;
        try {
            value = Long.parseLong(r.currentText("int64"));
        }
        catch (NumberFormatException e) {
            r.parseExpected("int64", e);
        }
        r.moveNext();
        return value;
    };
    public static final JsonLfDecoder<Instant> timestamp = r -> {
        r.expectIsAt("timestamp", JsonToken.VALUE_STRING);
        Instant value = null;
        try {
            value = Instant.parse(r.currentText("timestamp")).truncatedTo(ChronoUnit.MICROS);
        }
        catch (DateTimeParseException e) {
            r.parseExpected("valid ISO 8601 date and time in UTC", e);
        }
        r.moveNext();
        return value;
    };
    public static final JsonLfDecoder<LocalDate> date = r -> {
        r.expectIsAt("date", JsonToken.VALUE_STRING);
        LocalDate value = null;
        try {
            value = LocalDate.parse(r.currentText("date"));
        }
        catch (DateTimeParseException e) {
            r.parseExpected("valid ISO 8601 date", e);
        }
        r.moveNext();
        return value;
    };
    public static final JsonLfDecoder<String> text = r -> {
        r.expectIsAt("text", JsonToken.VALUE_STRING);
        String value = r.currentText("valid textual value");
        r.moveNext();
        return value;
    };
    public static final JsonLfDecoder<String> party = text;
    private static final int MAX_NUMERIC_PRECISION = 38;

    public static JsonLfDecoder<BigDecimal> numeric(int scale) {
        assert (scale >= 0) : "negative numeric scale " + scale;
        return r -> {
            r.expectIsAt("numeric", JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_STRING);
            BigDecimal value = null;
            try {
                value = new BigDecimal(r.currentText("numeric"));
            }
            catch (NumberFormatException e) {
                r.parseExpected("numeric", e);
            }
            int orderMag = 38 - scale;
            if (value.precision() - value.scale() > orderMag) {
                r.parseExpected(String.format("numeric in range (-10^%s, 10^%s)", orderMag, orderMag));
            }
            if (value.scale() > scale) {
                value = value.setScale(scale, RoundingMode.HALF_EVEN);
            }
            r.moveNext();
            return value;
        };
    }

    public static <C extends ContractId<?>> JsonLfDecoder<C> contractId(Function<String, C> constr) {
        return r -> {
            String id = text.decode(r);
            return (ContractId)constr.apply(id);
        };
    }

    public static <T> JsonLfDecoder<List<T>> list(JsonLfDecoder<T> decodeItem) {
        return r -> {
            ArrayList list = new ArrayList();
            r.readStartArray();
            while (r.notEndArray()) {
                Object item = decodeItem.decode(r);
                list.add(item);
            }
            r.readEndArray();
            return list;
        };
    }

    public static <V> JsonLfDecoder<Map<String, V>> textMap(JsonLfDecoder<V> decodeValue) {
        return r -> {
            LinkedHashMap map = new LinkedHashMap();
            r.readStartObject();
            while (r.notEndObject()) {
                String key = r.readFieldName().name;
                Object val = decodeValue.decode(r);
                map.put(key, val);
            }
            r.readEndObject();
            return map;
        };
    }

    public static <K, V> JsonLfDecoder<Map<K, V>> genMap(JsonLfDecoder<K> decodeKey, JsonLfDecoder<V> decodeVal) {
        return r -> {
            LinkedHashMap map = new LinkedHashMap();
            r.readStartArray();
            while (r.notEndArray()) {
                r.readStartArray();
                Object key = decodeKey.decode(r);
                Object val = decodeVal.decode(r);
                r.readEndArray();
                map.put(key, val);
            }
            r.readEndArray();
            return map;
        };
    }

    public static <T> JsonLfDecoder<Optional<T>> optional(JsonLfDecoder<T> decodeVal) {
        return r -> {
            if (r.isNull()) {
                r.moveNext();
                return Optional.empty();
            }
            Object some = decodeVal.decode(r);
            assert (!(some instanceof Optional)) : "Used `optional` to decode a " + some.getClass() + " but `optionalNested` must be used for the outer decoders of nested Optional";
            return Optional.of(some);
        };
    }

    public static <T> JsonLfDecoder<Optional<Optional<T>>> optionalNested(JsonLfDecoder<Optional<T>> decodeVal) {
        return r -> {
            if (r.isNull()) {
                r.moveNext();
                return Optional.empty();
            }
            r.readStartArray();
            if (r.isNull()) {
                r.parseExpected("] or item");
            }
            Optional val = r.notEndArray() ? (Optional)decodeVal.decode(r) : Optional.empty();
            r.readEndArray();
            return Optional.of(val);
        };
    }

    public static <E extends Enum<E>> JsonLfDecoder<E> enumeration(Map<String, E> damlNameToEnum) {
        return r -> r.readFromText(damlNameToEnum::get, new ArrayList<String>(damlNameToEnum.keySet()));
    }

    public static <T> JsonLfDecoder<T> variant(List<String> tagNames, Function<String, JsonLfDecoder<? extends T>> decoderByName) {
        return r -> {
            r.readStartObject();
            Object result = null;
            JsonLfReader.FieldName field = r.readFieldName();
            switch (field.name) {
                case "tag": {
                    JsonLfDecoder decoder = (JsonLfDecoder)r.readFromText(decoderByName, tagNames);
                    JsonLfReader.FieldName valueField = r.readFieldName();
                    if (!valueField.name.equals("value")) {
                        r.parseExpected("field value", null, valueField.name, valueField.loc);
                    }
                    result = decoder.decode(r);
                    break;
                }
                case "value": {
                    JsonLfReader.UnknownValue unknown = JsonLfReader.UnknownValue.read(r);
                    JsonLfReader.FieldName tagField = r.readFieldName();
                    if (!tagField.name.equals("tag")) {
                        r.parseExpected("field tag", null, tagField.name, tagField.loc);
                    }
                    JsonLfDecoder decoder = (JsonLfDecoder)r.readFromText(decoderByName, tagNames);
                    result = unknown.decodeWith(decoder);
                    break;
                }
                default: {
                    r.parseExpected("field tag or value", null, field.name, field.loc);
                }
            }
            r.readEndObject();
            return result;
        };
    }

    public static <T> JsonLfDecoder<T> record(List<String> argNames, Function<String, JavaArg<? extends Object>> argsByName, Function<Object[], T> constr) {
        return r -> {
            Object[] args = new Object[argNames.size()];
            if (r.isStartObject()) {
                r.readStartObject();
                while (r.notEndObject()) {
                    JsonLfReader.FieldName field = r.readFieldName();
                    JavaArg constrArg = (JavaArg)argsByName.apply(field.name);
                    if (constrArg == null) {
                        r.unknownField(field.name, argNames, field.loc);
                        continue;
                    }
                    args[constrArg.index] = constrArg.decode.decode(r);
                }
                r.readEndObject();
            } else if (r.isStartArray()) {
                r.readStartArray();
                for (String fieldName : argNames) {
                    JavaArg field = (JavaArg)argsByName.apply(fieldName);
                    args[field.index] = field.decode.decode(r);
                }
                r.readEndArray();
            } else {
                r.parseExpected("object or array");
            }
            for (String argName : argNames) {
                JavaArg arg = (JavaArg)argsByName.apply(argName);
                if (args[arg.index] != null) continue;
                if (arg.defaultVal == null) {
                    r.missingField(argName);
                }
                args[arg.index] = arg.defaultVal;
            }
            return constr.apply(args);
        };
    }

    public static <T> T cast(Object o) {
        return (T)o;
    }

    public static class JavaArg<T> {
        final int index;
        final JsonLfDecoder<T> decode;
        final T defaultVal;

        private JavaArg(int index, JsonLfDecoder<T> decode, T defaultVal) {
            this.index = index;
            this.decode = decode;
            this.defaultVal = defaultVal;
        }

        public static <T> JavaArg<T> at(int index, JsonLfDecoder<T> decode, T defaultVal) {
            return new JavaArg<T>(index, decode, defaultVal);
        }

        public static <T> JavaArg<T> at(int index, JsonLfDecoder<T> decode) {
            return new JavaArg<Object>(index, decode, null);
        }
    }
}

