/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.StateServiceOuterClass;
import com.daml.ledger.javaapi.data.ContractEntry;
import com.daml.ledger.javaapi.data.CreatedEvent;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ActiveContract
implements ContractEntry {
    private final @NonNull CreatedEvent createdEvent;
    private final @NonNull String synchronizerId;
    private final long reassignmentCounter;

    public ActiveContract(@NonNull CreatedEvent createdEvent, @NonNull String synchronizerId, long reassignmentCounter) {
        this.createdEvent = createdEvent;
        this.synchronizerId = synchronizerId;
        this.reassignmentCounter = reassignmentCounter;
    }

    @Override
    public @NonNull CreatedEvent getCreatedEvent() {
        return this.createdEvent;
    }

    public @NonNull String getSynchronizerId() {
        return this.synchronizerId;
    }

    public long getReassignmentCounter() {
        return this.reassignmentCounter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveContract that = (ActiveContract)o;
        return Objects.equals(this.createdEvent, that.createdEvent) && Objects.equals(this.synchronizerId, that.synchronizerId) && Objects.equals(this.reassignmentCounter, that.reassignmentCounter);
    }

    public int hashCode() {
        return Objects.hash(this.createdEvent, this.synchronizerId, this.reassignmentCounter);
    }

    public String toString() {
        return "ActiveContract{createdEvent=" + this.createdEvent + ", synchronizerId='" + this.synchronizerId + "', reassignmentCounter=" + this.reassignmentCounter + "}";
    }

    public StateServiceOuterClass.ActiveContract toProto() {
        return StateServiceOuterClass.ActiveContract.newBuilder().setCreatedEvent(this.getCreatedEvent().toProto()).setSynchronizerId(this.getSynchronizerId()).setReassignmentCounter(this.getReassignmentCounter()).build();
    }

    public static ActiveContract fromProto(StateServiceOuterClass.ActiveContract activeContract) {
        return new ActiveContract(CreatedEvent.fromProto(activeContract.getCreatedEvent()), activeContract.getSynchronizerId(), activeContract.getReassignmentCounter());
    }
}

