/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.EventOuterClass;
import com.daml.ledger.javaapi.data.Event;
import com.daml.ledger.javaapi.data.Identifier;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ArchivedEvent
implements Event {
    private final List<String> witnessParties;
    private final Long offset;
    private final Integer nodeId;
    private final Identifier templateId;
    private final String packageName;
    private final String contractId;
    private final List<Identifier> implementedInterfaces;

    public ArchivedEvent(@NonNull List<@NonNull String> witnessParties, @NonNull Long offset, @NonNull Integer nodeId, @NonNull Identifier templateId, @NonNull String packageName, @NonNull String contractId, @NonNull List<@NonNull Identifier> implementedInterfaces) {
        this.witnessParties = witnessParties;
        this.offset = offset;
        this.nodeId = nodeId;
        this.templateId = templateId;
        this.packageName = packageName;
        this.contractId = contractId;
        this.implementedInterfaces = implementedInterfaces;
    }

    @Override
    public @NonNull List<@NonNull String> getWitnessParties() {
        return this.witnessParties;
    }

    @Override
    public @NonNull Long getOffset() {
        return this.offset;
    }

    @Override
    public @NonNull Integer getNodeId() {
        return this.nodeId;
    }

    @Override
    public @NonNull Identifier getTemplateId() {
        return this.templateId;
    }

    @Override
    public @NonNull String getPackageName() {
        return this.packageName;
    }

    @Override
    public @NonNull String getContractId() {
        return this.contractId;
    }

    public @NonNull List<Identifier> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchivedEvent that = (ArchivedEvent)o;
        return Objects.equals(this.witnessParties, that.witnessParties) && Objects.equals(this.offset, that.offset) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.templateId, that.templateId) && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.contractId, that.contractId) && Objects.equals(this.implementedInterfaces, that.implementedInterfaces);
    }

    public int hashCode() {
        return Objects.hash(this.witnessParties, this.offset, this.nodeId, this.templateId, this.packageName, this.contractId, this.implementedInterfaces);
    }

    public String toString() {
        return "ArchivedEvent{witnessParties=" + this.witnessParties + ", offset=" + this.offset + ", nodeId=" + this.nodeId + ", packageName=" + this.packageName + ", templateId=" + this.templateId + ", contractId='" + this.contractId + ", implementedInterfaces='" + this.implementedInterfaces + "'}";
    }

    public EventOuterClass.ArchivedEvent toProto() {
        return EventOuterClass.ArchivedEvent.newBuilder().setContractId(this.getContractId()).setOffset(this.getOffset()).setNodeId(this.getNodeId()).setTemplateId(this.getTemplateId().toProto()).setPackageName(this.getPackageName()).addAllWitnessParties(this.getWitnessParties()).addAllImplementedInterfaces(this.getImplementedInterfaces().stream().map(Identifier::toProto).toList()).build();
    }

    public static ArchivedEvent fromProto(EventOuterClass.ArchivedEvent archivedEvent) {
        return new ArchivedEvent((List<String>)archivedEvent.getWitnessPartiesList(), archivedEvent.getOffset(), archivedEvent.getNodeId(), Identifier.fromProto(archivedEvent.getTemplateId()), archivedEvent.getPackageName(), archivedEvent.getContractId(), archivedEvent.getImplementedInterfacesList().stream().map(Identifier::fromProto).toList());
    }
}

