/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.ReassignmentOuterClass;
import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.ReassignmentEvent;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class AssignedEvent
implements ReassignmentEvent {
    private final @NonNull String source;
    private final @NonNull String target;
    private final @NonNull String reassignmentId;
    private final @NonNull String submitter;
    private final long reassignmentCounter;
    private final @NonNull CreatedEvent createdEvent;

    public AssignedEvent(@NonNull String source, @NonNull String target, @NonNull String reassignmentId, @NonNull String submitter, long reassignmentCounter, @NonNull CreatedEvent createdEvent) {
        this.source = source;
        this.target = target;
        this.reassignmentId = reassignmentId;
        this.submitter = submitter;
        this.reassignmentCounter = reassignmentCounter;
        this.createdEvent = createdEvent;
    }

    public @NonNull String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public @NonNull String getReassignmentId() {
        return this.reassignmentId;
    }

    public @NonNull String getSubmitter() {
        return this.submitter;
    }

    public long getReassignmentCounter() {
        return this.reassignmentCounter;
    }

    public @NonNull CreatedEvent getCreatedEvent() {
        return this.createdEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignedEvent that = (AssignedEvent)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target) && Objects.equals(this.reassignmentId, that.reassignmentId) && Objects.equals(this.submitter, that.submitter) && Objects.equals(this.reassignmentCounter, that.reassignmentCounter) && Objects.equals(this.createdEvent, that.createdEvent);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target, this.reassignmentId, this.submitter, this.reassignmentCounter, this.createdEvent);
    }

    public String toString() {
        return "AssignedEvent{source=" + this.source + ", target=" + this.target + ", reassignmentId='" + this.reassignmentId + "', submitter=" + this.submitter + ", reassignmentCounter=" + this.reassignmentCounter + ", createdEvent=" + this.createdEvent + "}";
    }

    public ReassignmentOuterClass.AssignedEvent toProto() {
        return ReassignmentOuterClass.AssignedEvent.newBuilder().setSource(this.source).setTarget(this.target).setReassignmentId(this.reassignmentId).setSubmitter(this.submitter).setReassignmentCounter(this.reassignmentCounter).setCreatedEvent(this.getCreatedEvent().toProto()).build();
    }

    public static AssignedEvent fromProto(ReassignmentOuterClass.AssignedEvent assignedEvent) {
        return new AssignedEvent(assignedEvent.getSource(), assignedEvent.getTarget(), assignedEvent.getReassignmentId(), assignedEvent.getSubmitter(), assignedEvent.getReassignmentCounter(), CreatedEvent.fromProto(assignedEvent.getCreatedEvent()));
    }
}

