/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.CumulativeFilter;
import com.daml.ledger.javaapi.data.EventFormat;
import com.daml.ledger.javaapi.data.Filter;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.TransactionFormat;
import com.daml.ledger.javaapi.data.TransactionShape;
import com.daml.ledger.javaapi.data.UpdateFormat;
import com.daml.ledger.javaapi.data.codegen.Contract;
import com.daml.ledger.javaapi.data.codegen.ContractCompanion;
import com.daml.ledger.javaapi.data.codegen.ContractTypeCompanion;
import com.daml.ledger.javaapi.data.codegen.InterfaceCompanion;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ContractFilter<Ct> {
    private final ContractTypeCompanion<Ct, ?, ?, ?> companion;
    private final CumulativeFilter filter;
    private final boolean verbose;
    private final TransactionShape transactionShape;

    private ContractFilter(ContractTypeCompanion<Ct, ?, ?, ?> companion, CumulativeFilter filter, boolean verbose, TransactionShape transactionShape) {
        this.companion = companion;
        this.filter = filter;
        this.verbose = verbose;
        this.transactionShape = transactionShape;
    }

    public static <Ct> ContractFilter<Ct> of(ContractCompanion<Ct, ?, ?> companion) {
        CumulativeFilter filter = new CumulativeFilter(Collections.emptyMap(), Collections.singletonMap(companion.TEMPLATE_ID, Filter.Template.HIDE_CREATED_EVENT_BLOB), Optional.empty());
        return new ContractFilter<Ct>(companion, filter, false, TransactionShape.ACS_DELTA);
    }

    public static <Cid, View> ContractFilter<Contract<Cid, View>> of(InterfaceCompanion<?, Cid, View> companion) {
        CumulativeFilter filter = new CumulativeFilter(Collections.singletonMap(companion.TEMPLATE_ID, Filter.Interface.INCLUDE_VIEW_HIDE_CREATED_EVENT_BLOB), Collections.emptyMap(), Optional.empty());
        return new ContractFilter<Contract<Cid, View>>(companion, filter, false, TransactionShape.ACS_DELTA);
    }

    public ContractFilter<Ct> withIncludeCreatedEventBlob(boolean includeCreatedEventBlob) {
        Filter.Interface interfaceFilterConfig = includeCreatedEventBlob ? Filter.Interface.INCLUDE_VIEW_INCLUDE_CREATED_EVENT_BLOB : Filter.Interface.INCLUDE_VIEW_HIDE_CREATED_EVENT_BLOB;
        Filter.Template templateFilterConfig = includeCreatedEventBlob ? Filter.Template.INCLUDE_CREATED_EVENT_BLOB : Filter.Template.HIDE_CREATED_EVENT_BLOB;
        Map<@NonNull Identifier, Filter.Interface> interfaceFiltersWithCreatedEventBlob = this.filter.getInterfaceFilters().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> interfaceFilterConfig));
        Map<@NonNull Identifier, Filter.Template> templateFiltersWithCreatedEventBlob = this.filter.getTemplateFilters().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> templateFilterConfig));
        Optional<@NonNull Filter.Wildcard> includeCreatedEventBlobWildcard = this.filter.getWildcardFilter().map(w -> includeCreatedEventBlob ? Filter.Wildcard.INCLUDE_CREATED_EVENT_BLOB : Filter.Wildcard.HIDE_CREATED_EVENT_BLOB);
        CumulativeFilter filterWithIncludedCreatedEventBlob = new CumulativeFilter(interfaceFiltersWithCreatedEventBlob, templateFiltersWithCreatedEventBlob, includeCreatedEventBlobWildcard);
        return new ContractFilter<Ct>(this.companion, filterWithIncludedCreatedEventBlob, this.verbose, this.transactionShape);
    }

    public ContractFilter<Ct> withVerbose(boolean verbose) {
        return new ContractFilter<Ct>(this.companion, this.filter, verbose, this.transactionShape);
    }

    public ContractFilter<Ct> withTransactionShape(TransactionShape transactionShape) {
        return new ContractFilter<Ct>(this.companion, this.filter, this.verbose, transactionShape);
    }

    public Ct toContract(CreatedEvent createdEvent) throws IllegalArgumentException {
        return this.companion.fromCreatedEvent(createdEvent);
    }

    public UpdateFormat updateFormat(Optional<Set<String>> parties) {
        return ContractFilter.updateFormat(this.filter, parties, this.verbose, this.transactionShape);
    }

    private static UpdateFormat updateFormat(Filter filter, Optional<Set<String>> partiesO, boolean verbose, TransactionShape transactionShape) {
        TransactionFormat transactionFormat = ContractFilter.transactionFormat(filter, partiesO, verbose, transactionShape);
        return new UpdateFormat(Optional.of(transactionFormat), Optional.of(transactionFormat.getEventFormat()), Optional.empty());
    }

    public TransactionFormat transactionFormat(Optional<Set<String>> parties) {
        return ContractFilter.transactionFormat(this.filter, parties, this.verbose, this.transactionShape);
    }

    private static TransactionFormat transactionFormat(Filter filter, Optional<Set<String>> partiesO, boolean verbose, TransactionShape transactionShape) {
        EventFormat eventFormat = ContractFilter.eventFormat(filter, partiesO, verbose);
        return new TransactionFormat(eventFormat, transactionShape);
    }

    public EventFormat eventFormat(Optional<Set<String>> parties) {
        return ContractFilter.eventFormat(this.filter, parties, this.verbose);
    }

    private static EventFormat eventFormat(Filter filter, Optional<Set<String>> partiesO, boolean verbose) {
        Map<String, Filter> partyToFilters = partiesO.map(parties -> parties.stream().collect(Collectors.toMap(Function.identity(), x -> filter))).orElse(Collections.emptyMap());
        Optional<Filter> anyPartyFilterO = partiesO.isEmpty() ? Optional.of(filter) : Optional.empty();
        return new EventFormat(partyToFilters, anyPartyFilterO, verbose);
    }
}

