/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.EventOuterClass;
import com.daml.ledger.javaapi.data.DamlRecord;
import com.daml.ledger.javaapi.data.Event;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Value;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CreatedEvent
implements Event {
    private final @NonNull List<@NonNull String> witnessParties;
    private final Long offset;
    private final Integer nodeId;
    private final Identifier templateId;
    private final String packageName;
    private final String contractId;
    private final DamlRecord arguments;
    private final @NonNull Map<@NonNull Identifier, @NonNull DamlRecord> interfaceViews;
    private final @NonNull Map<@NonNull Identifier, @NonNull Status> failedInterfaceViews;
    private final Optional<Value> contractKey;
    private final @NonNull Set<@NonNull String> signatories;
    private final @NonNull Set<@NonNull String> observers;
    private final @NonNull ByteString createdEventBlob;
    public final @NonNull Instant createdAt;
    private final @NonNull Boolean acsDelta;
    private final @NonNull String representativePackageId;

    public CreatedEvent(@NonNull List<@NonNull String> witnessParties, @NonNull Long offset, @NonNull Integer nodeId, @NonNull Identifier templateId, @NonNull String packageName, @NonNull String contractId, @NonNull DamlRecord arguments, @NonNull ByteString createdEventBlob, @NonNull Map<@NonNull Identifier, @NonNull DamlRecord> interfaceViews, @NonNull Map<@NonNull Identifier, @NonNull Status> failedInterfaceViews, @NonNull Optional<Value> contractKey, @NonNull Collection<@NonNull String> signatories, @NonNull Collection<@NonNull String> observers, @NonNull Instant createdAt, @NonNull Boolean acsDelta, @NonNull String representativePackageId) {
        this.witnessParties = List.copyOf(witnessParties);
        this.offset = offset;
        this.nodeId = nodeId;
        this.templateId = templateId;
        this.packageName = packageName;
        this.contractId = contractId;
        this.arguments = arguments;
        this.createdEventBlob = createdEventBlob;
        this.interfaceViews = Map.copyOf(interfaceViews);
        this.failedInterfaceViews = Map.copyOf(failedInterfaceViews);
        this.contractKey = contractKey;
        this.signatories = Set.copyOf(signatories);
        this.observers = Set.copyOf(observers);
        this.createdAt = createdAt;
        this.acsDelta = acsDelta;
        this.representativePackageId = representativePackageId;
    }

    @Override
    public @NonNull List<@NonNull String> getWitnessParties() {
        return this.witnessParties;
    }

    @Override
    public @NonNull Long getOffset() {
        return this.offset;
    }

    @Override
    public @NonNull Integer getNodeId() {
        return this.nodeId;
    }

    @Override
    public @NonNull Identifier getTemplateId() {
        return this.templateId;
    }

    @Override
    public @NonNull String getPackageName() {
        return this.packageName;
    }

    @Override
    public @NonNull String getContractId() {
        return this.contractId;
    }

    public @NonNull DamlRecord getArguments() {
        return this.arguments;
    }

    public ByteString getCreatedEventBlob() {
        return this.createdEventBlob;
    }

    public @NonNull Map<@NonNull Identifier, @NonNull DamlRecord> getInterfaceViews() {
        return this.interfaceViews;
    }

    public @NonNull Map<@NonNull Identifier, @NonNull Status> getFailedInterfaceViews() {
        return this.failedInterfaceViews;
    }

    public @NonNull Optional<Value> getContractKey() {
        return this.contractKey;
    }

    public @NonNull Set<@NonNull String> getSignatories() {
        return this.signatories;
    }

    public @NonNull Set<@NonNull String> getObservers() {
        return this.observers;
    }

    public @NonNull Instant getCreatedAt() {
        return this.createdAt;
    }

    public boolean isAcsDelta() {
        return this.acsDelta;
    }

    public @NonNull String getRepresentativePackageId() {
        return this.representativePackageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatedEvent that = (CreatedEvent)o;
        return Objects.equals(this.witnessParties, that.witnessParties) && Objects.equals(this.offset, that.offset) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.templateId, that.templateId) && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.contractId, that.contractId) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.createdEventBlob, that.createdEventBlob) && Objects.equals(this.interfaceViews, that.interfaceViews) && Objects.equals(this.failedInterfaceViews, that.failedInterfaceViews) && Objects.equals(this.contractKey, that.contractKey) && Objects.equals(this.signatories, that.signatories) && Objects.equals(this.observers, that.observers) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.acsDelta, that.acsDelta) && Objects.equals(this.representativePackageId, that.representativePackageId);
    }

    public int hashCode() {
        return Objects.hash(this.witnessParties, this.offset, this.nodeId, this.templateId, this.packageName, this.contractId, this.arguments, this.createdEventBlob, this.interfaceViews, this.failedInterfaceViews, this.contractKey, this.signatories, this.observers, this.createdAt, this.acsDelta, this.representativePackageId);
    }

    public String toString() {
        return "CreatedEvent{witnessParties=" + this.witnessParties + ", offset=" + this.offset + ", nodeId=" + this.nodeId + ", templateId=" + this.templateId + ", packageName=" + this.packageName + ", contractId='" + this.contractId + "', arguments=" + this.arguments + ", createdEventBlob=" + this.createdEventBlob + ", interfaceViews=" + this.interfaceViews + ", failedInterfaceViews=" + this.failedInterfaceViews + "', contractKey=" + this.contractKey + ", signatories=" + this.signatories + ", observers=" + this.observers + ", createdAt=" + this.createdAt + ", acsDelta=" + this.acsDelta + ", representativePackageId=" + this.representativePackageId + "}";
    }

    public @NonNull EventOuterClass.CreatedEvent toProto() {
        EventOuterClass.CreatedEvent.Builder builder = EventOuterClass.CreatedEvent.newBuilder().setContractId(this.getContractId()).setCreateArguments(this.getArguments().toProtoRecord()).setCreatedEventBlob(this.createdEventBlob).addAllInterfaceViews(Stream.concat(CreatedEvent.toProtoInterfaceViews(this.interfaceViews, (b, dr) -> b.setViewValue(dr.toProtoRecord())), CreatedEvent.toProtoInterfaceViews(this.failedInterfaceViews, (b, status) -> b.setViewStatus((Status)status))).collect(Collectors.toUnmodifiableList())).setOffset(this.getOffset()).setNodeId(this.getNodeId()).setTemplateId(this.getTemplateId().toProto()).setPackageName(this.getPackageName()).addAllWitnessParties(this.getWitnessParties()).addAllSignatories(this.getSignatories()).addAllObservers(this.getObservers()).setCreatedAt(Timestamp.newBuilder().setSeconds(this.createdAt.getEpochSecond()).setNanos(this.createdAt.getNano()).build()).setAcsDelta(this.isAcsDelta()).setRepresentativePackageId(this.getRepresentativePackageId());
        this.contractKey.ifPresent(a -> builder.setContractKey(a.toProto()));
        return builder.build();
    }

    private static <V> Stream<EventOuterClass.InterfaceView> toProtoInterfaceViews(Map<Identifier, V> views, BiFunction<EventOuterClass.InterfaceView.Builder, V, EventOuterClass.InterfaceView.Builder> addV) {
        return views.entrySet().stream().map(e -> ((EventOuterClass.InterfaceView.Builder)addV.apply(EventOuterClass.InterfaceView.newBuilder().setInterfaceId(((Identifier)e.getKey()).toProto()), e.getValue())).build());
    }

    public static CreatedEvent fromProto(EventOuterClass.CreatedEvent createdEvent) {
        Map<Boolean, List<EventOuterClass.InterfaceView>> splitInterfaceViews = createdEvent.getInterfaceViewsList().stream().collect(Collectors.partitioningBy(EventOuterClass.InterfaceView::hasViewValue));
        return new CreatedEvent((List<String>)createdEvent.getWitnessPartiesList(), createdEvent.getOffset(), createdEvent.getNodeId(), Identifier.fromProto(createdEvent.getTemplateId()), createdEvent.getPackageName(), createdEvent.getContractId(), DamlRecord.fromProto(createdEvent.getCreateArguments()), createdEvent.getCreatedEventBlob(), splitInterfaceViews.get(true).stream().collect(Collectors.toUnmodifiableMap(iv -> Identifier.fromProto(iv.getInterfaceId()), iv -> DamlRecord.fromProto(iv.getViewValue()))), splitInterfaceViews.get(false).stream().collect(Collectors.toUnmodifiableMap(iv -> Identifier.fromProto(iv.getInterfaceId()), EventOuterClass.InterfaceView::getViewStatus)), createdEvent.hasContractKey() ? Optional.of(Value.fromProto(createdEvent.getContractKey())) : Optional.empty(), (Collection<String>)createdEvent.getSignatoriesList(), (Collection<String>)createdEvent.getObserversList(), Instant.ofEpochSecond(createdEvent.getCreatedAt().getSeconds(), createdEvent.getCreatedAt().getNanos()), createdEvent.getAcsDelta(), createdEvent.getRepresentativePackageId());
    }
}

